/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.Beschreibung;
import frei_benno.dynamic.model.Gleichungen;
import frei_benno.dynamic.model.Graphic;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelFile;
import frei_benno.dynamic.model.Simulation;
import frei_benno.dynamic.model.TreeElement;
import frei_benno.dynamic.model.array.GraphicArray;
import frei_benno.dynamic.model.array.SimulationArray;
import frei_benno.dynamic.model.graphic.BeschreibungPanel;
import frei_benno.dynamic.model.graphic.GleichungenPanel;
import frei_benno.dynamic.model.graphic.GraphicPanel;
import frei_benno.dynamic.model.graphic.SimulationPanel;
import frei_benno.dynamic.model.id.IDElement;
import frei_benno.dynamic.model.id.IDHandler;
import frei_benno.dynamic.toolkit.IconGetter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultMutableTreeNode;

public class ModelFolder {
    private JFrame frame;
    private SimulationArray simArr;
    private GraphicArray grArr;
    private GraphicArray grPhaseArr;
    private IDHandler idHandler;
    private Model model = new Model(this);
    private Gleichungen gleichungen;
    private Beschreibung beschreibung;
    private JTabbedPane register;
    private IDElement id;
    private ModelFile modelFile;

    public ModelFolder(ModelFile modelFile) {
        this.modelFile = modelFile;
        this.id = modelFile.getIdHandler().createNewID("MODELL", this);
        this.idHandler = new IDHandler(this);
        this.simArr = new SimulationArray(this);
        this.grArr = new GraphicArray(this);
        this.grPhaseArr = new GraphicArray(this);
        this.gleichungen = new Gleichungen(this.model);
        this.beschreibung = new Beschreibung(this);
    }

    public void writeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(this.id.getName());
        TreeElement treeElement = new TreeElement();
        treeElement.setModelFolderId(this.id);
        treeElement.setDefinition(0);
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(treeElement);
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        treeElement = new TreeElement();
        treeElement.setModelFolderId(this.id);
        treeElement.setElementId(this.beschreibung.getId());
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(treeElement);
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        treeElement = new TreeElement();
        treeElement.setModelFolderId(this.id);
        treeElement.setDefinition(2);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode(treeElement);
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode("Zeitdiagramme");
        int n = 0;
        while (n < this.grArr.length()) {
            treeElement = new TreeElement();
            treeElement.setModelFolderId(this.id);
            treeElement.setElementId(this.grArr.getElement(n).getId());
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeElement);
            defaultMutableTreeNode4.add(defaultMutableTreeNode2);
            ++n;
        }
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode4 = new DefaultMutableTreeNode("Phasendiagramme");
        int n2 = 0;
        while (n2 < this.grPhaseArr.length()) {
            treeElement = new TreeElement();
            treeElement.setModelFolderId(this.id);
            treeElement.setElementId(this.grPhaseArr.getElement(n2).getId());
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeElement);
            defaultMutableTreeNode4.add(defaultMutableTreeNode2);
            ++n2;
        }
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
    }

    public Beschreibung getBeschreibung() {
        return this.beschreibung;
    }

    public Gleichungen getGleichungen() {
        return this.gleichungen;
    }

    public IDElement getId() {
        return this.id;
    }

    public void setId(IDElement iDElement) {
        this.id = iDElement;
    }

    public SimulationArray getSimulationArray() {
        return this.simArr;
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ModelFile getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(ModelFile modelFile) {
        this.modelFile = modelFile;
    }

    public IDHandler getIdHandler() {
        return this.idHandler;
    }

    public void doValidation() {
        this.model.doValidation();
        this.gleichungen.doValidation();
    }

    public Model getModel() {
        return this.model;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        this.idHandler.save(dataOutputStream);
        this.model.save(dataOutputStream);
        this.beschreibung.save(dataOutputStream);
        this.simArr.save(dataOutputStream);
        this.grArr.save(dataOutputStream);
        this.grPhaseArr.save(dataOutputStream);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.id = this.modelFile.getIdHandler().loadId(dataInputStream.readInt(), this);
        this.idHandler.setLoadingStatus(true);
        this.idHandler.load(dataInputStream);
        this.model.load(dataInputStream);
        this.beschreibung.load(dataInputStream);
        this.simArr.load(dataInputStream);
        this.grArr.load(dataInputStream);
        this.grPhaseArr.load(dataInputStream);
        this.idHandler.setLoadingStatus(false);
        this.doValidation();
    }

    public void createNewSimulation() {
        if (this.model.isValid() && !this.model.isEmpty()) {
            Simulation simulation = new Simulation(this.model);
            this.simArr.addElement(simulation);
            SimulationPanel simulationPanel = new SimulationPanel();
            simulationPanel.setSimulation(simulation);
            this.register.add(simulationPanel);
            this.register.setSelectedComponent(simulationPanel);
            int n = this.register.indexOfComponent(simulationPanel);
            this.register.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconSimulation.gif"));
            simulationPanel.einstellungenBearbeiten();
        } else {
            if (!this.model.isValid()) {
                Message.write("ERROR: Neue Simulation nicht m\u00f6glich, das Modell ist nicht g\u00fcltig");
            }
            if (this.model.isEmpty()) {
                Message.write("ERROR: Neue Simulation nicht m\u00f6glich. Es wurde noch kein Modell erstellt.");
            }
        }
    }

    public void reloadAllGraphics() {
        this.grArr.reloadAll();
        this.grPhaseArr.reloadAll();
    }

    public void createNewTimeDiagram() {
        if (this.model.isValid() && this.simArr.length() > 0) {
            Graphic graphic = new Graphic(this);
            this.grArr.addElement(graphic);
            GraphicPanel graphicPanel = new GraphicPanel();
            graphicPanel.setGraphic(graphic);
            graphicPanel.einstellungenBearbeiten();
            graphic.initialCalculation();
            this.register.add(graphicPanel);
            this.register.setSelectedComponent(graphicPanel);
            int n = this.register.indexOfComponent(graphicPanel);
            this.register.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconZeitdiagramm.gif"));
        } else {
            if (!this.model.isValid()) {
                Message.write("ERROR: Neues Zeitdiagramm kann nicht erstellt werden. Das Modell ist ung\u00fcltig.");
            }
            if (this.simArr.length() == 0) {
                Message.write("ERROR: Neues Zeitdiagramm kann nicht erstellt werden. Es sind keine Simulationsdaten vorhanden");
            }
        }
    }

    public void createNewPhaseDiagram() {
        if (this.model.isValid() && this.simArr.length() > 0) {
            Graphic graphic = new Graphic(this, false);
            this.grPhaseArr.addElement(graphic);
            GraphicPanel graphicPanel = new GraphicPanel();
            graphicPanel.setGraphic(graphic);
            graphicPanel.einstellungenBearbeiten();
            graphic.initialCalculation();
            this.register.add(graphicPanel);
            this.register.setSelectedComponent(graphicPanel);
            int n = this.register.indexOfComponent(graphicPanel);
            this.register.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconPhasendiagramm.gif"));
        } else {
            if (!this.model.isValid()) {
                Message.write("ERROR: Neues Phasendiagramm kann nicht erstellt werden. Das Modell ist ung\u00fcltig.");
            }
            if (this.simArr.length() == 0) {
                Message.write("ERROR: Neues Phasendiagramm kann nicht erstellt werden. Es sind keine Simulationsdaten vorhanden");
            }
        }
    }

    public void setRegister(JTabbedPane jTabbedPane) {
        this.register = jTabbedPane;
        if (this.register != null) {
            this.register.add(this.model.getModelPanel());
            int n = jTabbedPane.indexOfComponent(this.model.getModelPanel());
            jTabbedPane.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconModell.gif"));
            GleichungenPanel gleichungenPanel = new GleichungenPanel();
            this.gleichungen.doValidation();
            gleichungenPanel.setGleichungen(this.gleichungen);
            this.register.add(gleichungenPanel);
            n = jTabbedPane.indexOfComponent(gleichungenPanel);
            this.register.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconGleichungen.gif"));
            gleichungenPanel.refresh();
            BeschreibungPanel beschreibungPanel = new BeschreibungPanel();
            beschreibungPanel.setBeschreibung(this.beschreibung);
            this.register.add(beschreibungPanel);
            n = jTabbedPane.indexOfComponent(beschreibungPanel);
            jTabbedPane.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconGleichungen.gif"));
            int n2 = 0;
            while (n2 < this.simArr.length()) {
                SimulationPanel simulationPanel = new SimulationPanel();
                simulationPanel.setSimulation(this.simArr.getElement(n2));
                this.register.add(simulationPanel);
                this.register.setSelectedComponent(simulationPanel);
                n = this.register.indexOfComponent(simulationPanel);
                jTabbedPane.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconSimulation.gif"));
                simulationPanel.simulate();
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.grArr.length()) {
                GraphicPanel graphicPanel = new GraphicPanel();
                graphicPanel.setGraphic(this.grArr.getElement(n3));
                this.register.add(graphicPanel);
                this.register.setSelectedComponent(graphicPanel);
                n = this.register.indexOfComponent(graphicPanel);
                this.register.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconZeitdiagramm.gif"));
                this.grArr.getElement(n3).reload();
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.grPhaseArr.length()) {
                GraphicPanel graphicPanel = new GraphicPanel();
                graphicPanel.setGraphic(this.grPhaseArr.getElement(n4));
                this.register.add(graphicPanel);
                this.register.setSelectedComponent(graphicPanel);
                n = this.register.indexOfComponent(graphicPanel);
                this.register.setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconPhasendiagramm.gif"));
                this.grPhaseArr.getElement(n4).reload();
                ++n4;
            }
            jTabbedPane.setSelectedComponent(this.model.getModelPanel());
        }
    }

    public void removeRegister() {
        if (this.register != null) {
            this.register.removeAll();
        }
        this.beschreibung.removeTextArea();
        this.register = null;
    }

    public String toString() {
        if (this.id != null) {
            return "  " + this.id.getName();
        }
        return "  EIN MODELL";
    }

    public void simulateAll() {
        this.simArr.simulateAll();
    }

    public void removeSimulation(Simulation simulation) {
        this.simArr.removeElement(simulation);
    }

    public void removeGraphic(Graphic graphic) {
        this.grArr.removeElement(graphic);
    }
}

