/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.Bericht;
import frei_benno.dynamic.model.Graphic;
import frei_benno.dynamic.model.ModelFolder;
import frei_benno.dynamic.model.array.BerichtArray;
import frei_benno.dynamic.model.array.GraphicArray;
import frei_benno.dynamic.model.array.ModelFolderArray;
import frei_benno.dynamic.model.id.IDHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ModelFile
extends AbstractListModel {
    private JFrame frame;
    private IDHandler idHandler = new IDHandler(null);
    private ModelFolderArray mfArr = new ModelFolderArray(this);
    private GraphicArray grArr;
    private BerichtArray beArr;
    public static final String TITEL_MODELLE = "Modelle:";
    public static final String TITEL_DIAGRAMME = "Zeitdiagramme:";
    public static final String TITEL_BERICHTE = "Berichte:";

    public ModelFile() {
        this.mfArr.addElement(new ModelFolder(this));
        this.grArr = new GraphicArray(this);
        this.beArr = new BerichtArray(this);
    }

    public DefaultTreeModel getTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Datei");
        int n = 0;
        while (n < this.mfArr.length()) {
            this.mfArr.getElement(n).writeNodes(defaultMutableTreeNode);
            ++n;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Grafiken");
        int n2 = 0;
        while (n2 < this.grArr.length()) {
            this.grArr.getElement(n2).writeNodes(defaultMutableTreeNode2);
            ++n2;
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        return defaultTreeModel;
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ModelFolder[] getAllModelFolders() {
        return this.mfArr.getAll();
    }

    public void addModelFolder(ModelFolder modelFolder) {
        this.mfArr.addElement(modelFolder);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int countModelFolders() {
        return this.mfArr.length();
    }

    public void removeModelFolder(ModelFolder modelFolder) {
        this.mfArr.removeElement(modelFolder);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void addBericht(Bericht bericht) {
        this.beArr.addElement(bericht);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void removeBericht(Bericht bericht) {
        this.beArr.removeElement(bericht);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void addGraphic(Graphic graphic) {
        this.grArr.addElement(graphic);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void removeGraphic(Graphic graphic) {
        this.grArr.removeElement(graphic);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void fireChange() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public ModelFolder getModelFolder(int n) {
        if (n >= 0 && n < this.mfArr.length()) {
            return this.mfArr.getElement(n);
        }
        return this.mfArr.getElement(0);
    }

    public Graphic getGraphic(int n) {
        if (n >= 0 && n < this.grArr.length()) {
            return this.grArr.getElement(n);
        }
        return this.grArr.getElement(0);
    }

    public Bericht getBericht(int n) {
        if (n >= 0 && n < this.beArr.length()) {
            return this.beArr.getElement(n);
        }
        return this.beArr.getElement(0);
    }

    public Object getElementAt(int n) {
        if (n == 0) {
            return TITEL_MODELLE;
        }
        if (n > 0 && n < this.mfArr.length() + 1) {
            return this.mfArr.getElement(n - 1);
        }
        if (n == this.mfArr.length() + 1) {
            return TITEL_DIAGRAMME;
        }
        if (n > this.mfArr.length() + 1 && n < this.mfArr.length() + this.grArr.length() + 2) {
            return this.grArr.getElement(n - this.mfArr.length() - 2);
        }
        if (n == this.mfArr.length() + this.grArr.length() + 2) {
            return TITEL_BERICHTE;
        }
        if (n > this.mfArr.length() + this.grArr.length() + 2 && n < this.mfArr.length() + this.grArr.length() + this.beArr.length() + 3) {
            return this.beArr.getElement(n - this.mfArr.length() - this.grArr.length() - 3);
        }
        return null;
    }

    public int getSize() {
        return this.mfArr.length() + this.grArr.length() + this.beArr.length() + 3;
    }

    public IDHandler getIdHandler() {
        return this.idHandler;
    }

    public void setIdHandler(IDHandler iDHandler) {
        this.idHandler = iDHandler;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.idHandler.setLoadingStatus(true);
        this.idHandler.load(dataInputStream);
        this.mfArr.load(dataInputStream);
        this.grArr.load(dataInputStream);
        this.grArr.reloadAll();
        this.beArr.load(dataInputStream);
        this.idHandler.setLoadingStatus(false);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        this.idHandler.save(dataOutputStream);
        this.mfArr.save(dataOutputStream);
        this.grArr.save(dataOutputStream);
        this.beArr.save(dataOutputStream);
    }
}

