/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.Graphic;
import frei_benno.dynamic.model.LineProperties;
import frei_benno.dynamic.model.ModelFolder;
import frei_benno.dynamic.model.Simulation;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class Line {
    private Graphic graphic;
    private IDElement id;
    private IDElement simIdX;
    private IDElement eleIdX;
    private Simulation sim;
    private double[] time;
    private double[] values;
    private double mintime;
    private double maxtime;
    private double minval;
    private double maxval;
    private GeneralPath gp;
    private LineProperties lineProperties;
    private Shape drawingLine;

    public Line() {
        this.gp = new GeneralPath();
        this.lineProperties = new LineProperties();
    }

    public Line(Graphic graphic, IDElement iDElement, IDElement iDElement2) {
        block2: {
            this.gp = new GeneralPath();
            this.lineProperties = new LineProperties();
            this.graphic = graphic;
            this.id = graphic.getIdHandler().createNewID("LINIE", this);
            this.simIdX = iDElement;
            this.eleIdX = iDElement2;
            if (iDElement == null || iDElement2 == null) break block2;
            try {
                this.reloadData();
            }
            catch (Exception exception) {}
        }
    }

    public float drawLegende(Graphics2D graphics2D, float f, float f2, float f3) {
        Cloneable cloneable;
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("sansserif", 0, 12);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getGraphic().getModelFile() != null) {
            stringBuffer.append(this.sim.getModel().getModelFolder().getId().getName());
            textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            if (rectangle2D.getMaxX() - rectangle2D.getMinX() > (double)f2) {
                cloneable = new AffineTransform();
                ((AffineTransform)cloneable).scale((double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()), (double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()));
                font = font.deriveFont((AffineTransform)cloneable);
                textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
                rectangle2D = textLayout.getBounds();
            }
            graphics2D.setColor(Color.black);
            textLayout.draw(graphics2D, f, f3 - (float)rectangle2D.getMinY());
            f3 += (float)(rectangle2D.getMaxY() - rectangle2D.getMinY()) + 2.0f;
        }
        stringBuffer.setLength(0);
        stringBuffer.append(this.simIdX.getName());
        stringBuffer.append(".");
        stringBuffer.append(this.eleIdX.getName());
        textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
        rectangle2D = textLayout.getBounds();
        if (rectangle2D.getMaxX() - rectangle2D.getMinX() > (double)f2) {
            cloneable = new AffineTransform();
            ((AffineTransform)cloneable).scale((double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()), (double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()));
            font = font.deriveFont((AffineTransform)cloneable);
            textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
        }
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, f, f3 - (float)rectangle2D.getMinY());
        this.lineProperties.prepareGraphics(graphics2D);
        cloneable = new GeneralPath();
        ((Path2D)cloneable).reset();
        ((Path2D.Float)cloneable).moveTo(f, (f3 += (float)(rectangle2D.getMaxY() - rectangle2D.getMinY())) + 5.0f);
        ((Path2D.Float)cloneable).lineTo(f + f2, f3 + 5.0f);
        graphics2D.draw((Shape)((Object)cloneable));
        this.lineProperties.restoreGraphics(graphics2D);
        return f3 += 10.0f;
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public IDElement getSimulationId() {
        return this.simIdX;
    }

    public IDElement getElementId() {
        return this.eleIdX;
    }

    public void reloadData() {
        this.sim = (Simulation)this.simIdX.getOwner();
        this.time = this.sim.getTimeAxe();
        this.values = this.sim.getElementValues(this.eleIdX);
        this.mintime = this.time[0];
        this.maxtime = this.time[this.time.length - 1];
        this.minval = this.values[0];
        this.maxval = this.values[0];
        this.gp.reset();
        this.gp.moveTo((float)this.time[0], (float)this.values[0]);
        int n = 1;
        while (n < this.values.length) {
            if (this.values[n] < this.minval) {
                this.minval = this.values[n];
            }
            if (this.values[n] > this.maxval) {
                this.maxval = this.values[n];
            }
            this.gp.lineTo((float)this.time[n], (float)this.values[n]);
            ++n;
        }
    }

    public double getMinTime() {
        return this.mintime;
    }

    public double getMaxTime() {
        return this.maxtime;
    }

    public double getMinVal() {
        return this.minval;
    }

    public double getMaxVal() {
        return this.maxval;
    }

    public void recalculateShape(AffineTransform affineTransform) {
        this.drawingLine = this.gp.createTransformedShape(affineTransform);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent, AffineTransform affineTransform) {
        this.lineProperties.prepareGraphics(graphics2D);
        double d = (this.drawingLine.getBounds2D().getMaxY() - this.drawingLine.getBounds2D().getMinY()) / this.graphic.getRectValues().height;
        if (Double.isNaN(d) || Double.isInfinite(d) || d > 1000000.0) {
            Message.write("Linie " + this.toString() + " kann nicht mehr " + "dargestellt werden");
        } else {
            graphics2D.draw(this.drawingLine);
        }
        this.lineProperties.restoreGraphics(graphics2D);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.id = this.graphic.getIdHandler().loadId(dataInputStream.readInt(), this);
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            this.simIdX = this.graphic.getIdHandler().getIdElement(dataInputStream.readInt());
            this.eleIdX = this.graphic.getIdHandler().getIdElement(dataInputStream.readInt());
            this.lineProperties.load(dataInputStream);
        } else {
            int n = dataInputStream.readInt();
            ModelFolder modelFolder = (ModelFolder)this.graphic.getIdHandler().getIdElement(n).getOwner();
            this.simIdX = modelFolder.getIdHandler().getIdElement(dataInputStream.readInt());
            this.eleIdX = modelFolder.getIdHandler().getIdElement(dataInputStream.readInt());
            this.lineProperties.load(dataInputStream);
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        if (this.graphic.getModelFile() != null) {
            dataOutputStream.writeBoolean(false);
            dataOutputStream.writeInt(this.sim.getModel().getModelFolder().getId().getId());
        } else {
            dataOutputStream.writeBoolean(true);
        }
        dataOutputStream.writeInt(this.simIdX.getId());
        dataOutputStream.writeInt(this.eleIdX.getId());
        this.lineProperties.save(dataOutputStream);
    }

    public String toString() {
        return this.simIdX.getName() + "." + this.eleIdX.getName();
    }

    public LineProperties getLineProperties() {
        return this.lineProperties;
    }
}

