/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.ModelElementFunction;
import frei_benno.dynamic.model.graphic.EIntermediateValuePanel;
import frei_benno.dynamic.model.graphic.ModelElementPanel;
import frei_benno.dynamic.toolkit.ArcCalculator;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EIntermediateValue
extends ModelElementFunction
implements IDrawable2D {
    public static final double INTER_WIDTH = 30.0;
    public static final double INTER_HEIGHT = 30.0;
    private Arc2D.Double kreis = new Arc2D.Double(0.0, 0.0, 30.0, 30.0, 0.0, 360.0, 0);

    public EIntermediateValue(Model model) {
        super(model);
        this.setValid(false);
    }

    public double getWidth() {
        return 30.0;
    }

    public double getHeight() {
        return 30.0;
    }

    protected ModelElementPanel constructSpecificPanel() {
        return new EIntermediateValuePanel();
    }

    public Point2D.Double getConnectionPoint2D(Point2D.Double double_) {
        double d = ArcCalculator.getWinkel(this.centre, double_);
        return new Point2D.Double(this.centre.x - 15.0 * Math.cos(d), this.centre.y - 15.0 * Math.sin(d));
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        this.kreis.x = this.loc.x;
        this.kreis.y = this.loc.y;
        graphics2D.setColor(ModelElement.backgroundColor);
        graphics2D.fill(this.kreis);
        if (this.mouseOver) {
            graphics2D.setColor(ModelElement.mouseOverColor);
        } else {
            graphics2D.setColor(ModelElement.standardColor);
        }
        graphics2D.draw(this.kreis);
        graphics2D.setColor(ModelElement.fontColor);
        graphics2D.setFont(ModelElement.standardFont);
        graphics2D.drawString(this.id.getName(), (float)(this.centre.x - (double)(graphics2D.getFontMetrics().stringWidth(this.id.getName()) / 2)), (float)(this.loc.y + 30.0 + 1.0 + 12.0));
        if (!this.isValid()) {
            this.drawInvalidSymbol(graphics2D, this.centre);
        }
    }

    public void doValidation() {
        this.setValid(true);
        this.functionString.doValidation();
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        dataOutputStream.writeDouble(this.loc.x);
        dataOutputStream.writeDouble(this.loc.y);
        this.functionString.save(dataOutputStream);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.id = this.model.getModelFolder().getIdHandler().loadId(n, this);
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        this.setPosition(d, d2);
        this.functionString.load(dataInputStream);
    }
}

