/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.ModelFolder;
import frei_benno.dynamic.model.id.IDElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JTextArea;

public class Beschreibung {
    private StringBuffer beschreibung = new StringBuffer();
    private ModelFolder modelFolder;
    private IDElement id;
    private JTextArea text;

    public Beschreibung(ModelFolder modelFolder) {
        this.modelFolder = modelFolder;
        this.id = this.modelFolder.getIdHandler().createNewID("Beschreibung", this);
        this.beschreibung.append("Modellbeschreibung:\n\n");
    }

    public IDElement getId() {
        return this.id;
    }

    public void setText(String string) {
        this.beschreibung.setLength(0);
        this.beschreibung.append(string);
        this.text.setText(this.beschreibung.toString());
    }

    public String getText() {
        return this.beschreibung.toString();
    }

    public ModelFolder getModelFolder() {
        return this.modelFolder;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.id = this.modelFolder.getIdHandler().loadId(dataInputStream.readInt(), this);
        this.beschreibung.setLength(0);
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.beschreibung.append(dataInputStream.readChar());
            ++n2;
        }
        if (this.text != null) {
            this.text.setText(this.beschreibung.toString());
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        if (this.text != null) {
            this.setText(this.text.getText());
        }
        dataOutputStream.writeInt(this.beschreibung.length());
        dataOutputStream.writeChars(this.beschreibung.toString());
    }

    public void setTextArea(JTextArea jTextArea) {
        if (this.text != null) {
            this.beschreibung.setLength(0);
            this.beschreibung.append(this.text.getText());
        }
        this.text = jTextArea;
        this.text.setText(this.beschreibung.toString());
    }

    public void removeTextArea() {
        this.beschreibung.setLength(0);
        this.beschreibung.append(this.text.getText());
        this.text = null;
    }

    public JTextArea getTextArea() {
        return this.text;
    }
}

