/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.numeric;

import frei_benno.dynamic.formula.numeric.Simulator;

public class SimValueSaver {
    private static final int ARR_LEN = 100;
    private double[][] simValues;
    private int timepos;
    private int timelen;
    private int statepos;
    private int statelen;
    private int flowinterpos;
    private int flowinterlen;
    private int arr_pos;
    private Simulator simulator;
    private SimValueSaver ancestor = null;
    public static final int STATE = 0;
    public static final int FLOW = 1;

    public SimValueSaver(Simulator simulator, int n, int n2, int n3) {
        this.simulator = simulator;
        this.timelen = n;
        this.statelen = n2;
        this.flowinterlen = n3;
        this.timepos = 0;
        this.statepos = n;
        this.flowinterpos = n + n2;
        this.arr_pos = 0;
        this.simValues = new double[n + n2 + n3][100];
    }

    public void finishStep() {
        ++this.arr_pos;
        if (this.arr_pos >= 100) {
            SimValueSaver simValueSaver = new SimValueSaver(this.simulator, this.timelen, this.statelen, this.flowinterlen);
            simValueSaver.setAncestor(this);
            this.simulator.setSimValueSaver(simValueSaver);
        }
    }

    public void addTimeValue(int n, double d) {
        this.simValues[n + this.timepos][this.arr_pos] = d;
    }

    public void addStateValue(int n, double d) {
        this.simValues[n + this.statepos][this.arr_pos] = d;
    }

    public void addInterFlowValue(int n, double d) {
        this.simValues[n + this.flowinterpos][this.arr_pos] = d;
    }

    public void setAncestor(SimValueSaver simValueSaver) {
        this.ancestor = simValueSaver;
    }

    public SimValueSaver getAncestor() {
        return this.ancestor;
    }

    public int getLength() {
        if (this.ancestor != null) {
            return this.ancestor.getLength() + this.arr_pos;
        }
        return this.arr_pos;
    }

    public void println() {
    }

    public int copyValues(double[][] dArray) {
        int n = this.ancestor != null ? this.ancestor.copyValues(dArray) : 0;
        int n2 = 0;
        while (n2 < this.simValues.length) {
            System.arraycopy(this.simValues[n2], 0, dArray[n2], n, this.arr_pos);
            ++n2;
        }
        return n + this.arr_pos;
    }

    public double[][] getValArray() {
        double[][] dArray = new double[this.timelen + this.statelen + this.flowinterlen][this.getLength()];
        this.copyValues(dArray);
        return dArray;
    }

    public double getOldValue(int n, double d, double d2, double d3, boolean bl, double d4) {
        double d5;
        double d6;
        int n2 = this.arr_pos - 1;
        if (n2 < 0 && bl) {
            if (this.ancestor == null) {
                return d4;
            }
            return this.ancestor.getOldValue(n, 0.0, 0.0, d3, true, d4);
        }
        if (bl) {
            d6 = this.simValues[0][n2];
            d5 = this.simValues[n][n2];
            --n2;
        } else {
            d6 = d;
            d5 = d2;
        }
        while (n2 >= 0 && this.simValues[0][n2] > d3) {
            d6 = this.simValues[0][n2];
            d5 = this.simValues[n][n2];
            --n2;
        }
        if (n2 >= 0) {
            return this.simValues[n][n2] + (d5 - this.simValues[n][n2]) / (d6 - this.simValues[0][n2]) * (d3 - this.simValues[0][n2]);
        }
        if (this.ancestor != null) {
            return this.ancestor.getOldValue(n, d6, d5, d3, false, d4);
        }
        return d4;
    }

    public double oldValue(int n, int n2, double d, double d2) {
        int n3 = 1 + n * this.statelen + n2;
        return this.getOldValue(n3, 0.0, 0.0, d, true, d2);
    }
}

