/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.graphic;

import frei_benno.dynamic.formula.numeric.SimChooser;
import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.message.MessageDialog;
import frei_benno.dynamic.model.Simulation;
import frei_benno.dynamic.model.graphic.MainFrame;
import frei_benno.dynamic.model.graphic.SimulationPanel_buttonAktualisieren_actionAdapter;
import frei_benno.dynamic.model.graphic.SimulationPanel_buttonBearbeiten_actionAdapter;
import frei_benno.dynamic.model.graphic.SimulationPanel_buttonExport_actionAdapter;
import frei_benno.dynamic.table.JTableM;
import frei_benno.dynamic.toolkit.IconGetter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class SimulationPanel
extends JPanel
implements Printable {
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar jToolBar1 = new JToolBar();
    JButton buttonBearbeiten = new JButton();
    private Simulation simulation;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTableM jTable1 = new JTableM();
    JButton buttonAktualisieren = new JButton();
    JButton buttonExport = new JButton();

    public SimulationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.buttonBearbeiten.addActionListener(new SimulationPanel_buttonBearbeiten_actionAdapter(this));
        this.jToolBar1.setFloatable(false);
        this.jTable1.setMaximumSize(new Dimension(0, 0));
        this.jTable1.setMinimumSize(new Dimension(0, 0));
        this.jTable1.setAutoCreateColumnsFromModel(true);
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setColumnSelectionAllowed(true);
        this.buttonAktualisieren.addActionListener(new SimulationPanel_buttonAktualisieren_actionAdapter(this));
        this.buttonBearbeiten.setMaximumSize(new Dimension(20, 20));
        this.buttonBearbeiten.setMinimumSize(new Dimension(20, 20));
        this.buttonBearbeiten.setPreferredSize(new Dimension(20, 20));
        this.buttonBearbeiten.setMargin(new Insets(2, 2, 2, 2));
        this.buttonBearbeiten.setText("");
        this.buttonAktualisieren.setMaximumSize(new Dimension(20, 20));
        this.buttonAktualisieren.setMinimumSize(new Dimension(20, 20));
        this.buttonAktualisieren.setPreferredSize(new Dimension(20, 20));
        this.buttonAktualisieren.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAktualisieren.setText("");
        this.buttonExport.setMaximumSize(new Dimension(20, 20));
        this.buttonExport.setMinimumSize(new Dimension(20, 20));
        this.buttonExport.setPreferredSize(new Dimension(20, 20));
        this.buttonExport.setToolTipText("Tabelle nach CSV exportieren");
        this.buttonExport.setMargin(new Insets(2, 2, 2, 2));
        this.buttonExport.setText("");
        this.buttonExport.addActionListener(new SimulationPanel_buttonExport_actionAdapter(this));
        this.add((Component)this.jToolBar1, "North");
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add(this.jTable1);
        this.jToolBar1.add((Component)this.buttonBearbeiten, null);
        this.jToolBar1.add((Component)this.buttonAktualisieren, null);
        this.jToolBar1.add((Component)this.buttonExport, null);
        this.buttonBearbeiten.setIcon(IconGetter.getIcon("/frei_benno/dynamic/images/iconEinstellungen.gif"));
        this.buttonAktualisieren.setIcon(IconGetter.getIcon("/frei_benno/dynamic/images/iconAktualisieren.gif"));
        this.buttonExport.setIcon(IconGetter.getIcon("/frei_benno/dynamic/images/iconSave.gif"));
    }

    public void refreshTable() {
        this.simulation.fireTableStructureChanged();
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(Simulation simulation) {
        if (this.simulation != simulation) {
            this.jTable1.setModel(simulation);
            this.simulation = simulation;
        }
        this.refreshTable();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            this.jTable1.print(graphics);
            return 0;
        }
        return 1;
    }

    public void printContent() {
        block2: {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this);
            if (!printerJob.printDialog()) break block2;
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getName() {
        if (this.simulation != null) {
            return this.simulation.getId().getName();
        }
        return "XXX";
    }

    public void setName(String string) {
        if (this.simulation != null) {
            this.simulation.getId().setName(string);
        }
    }

    public void simulate() {
        this.simulation.getSimProperties().simulate(this.simulation.getModel(), this.simulation);
        this.refreshTable();
    }

    public void copyContent() {
        int[] nArray = this.jTable1.getSelectedRows();
        int[] nArray2 = this.jTable1.getSelectedColumns();
        int n = 0;
        while (n < nArray2.length) {
            nArray2[n] = this.jTable1.getColumnModel().getColumn(nArray2[n]).getModelIndex();
            ++n;
        }
        if (nArray.length == 0 || nArray2.length == 0) {
            Message.write("Keine Zellen markiert. Die ganze Tabelle wird kopiert");
            this.jTable1.selectAll();
            nArray = this.jTable1.getSelectedRows();
            nArray2 = this.jTable1.getSelectedColumns();
        } else {
            Message.write("Die markierten Zellen werden kopiert");
        }
        this.simulation.copyContent(nArray, nArray2);
    }

    public void einstellungenBearbeiten() {
        SimChooser simChooser = new SimChooser(this.simulation.getModel().getFrame(), "Einstellungen", true, this.simulation.getSimProperties(), this.simulation);
        simChooser.show();
        this.simulate();
        Container container = this.getParent();
        if (container != null && container instanceof JTabbedPane) {
            int n = ((JTabbedPane)container).getSelectedIndex();
            ((JTabbedPane)container).setTitleAt(n, this.simulation.getId().getName());
            ((JTabbedPane)container).setIconAt(n, IconGetter.getIcon("/frei_benno/dynamic/images/iconSimulation.gif"));
        }
    }

    void buttonBearbeiten_actionPerformed(ActionEvent actionEvent) {
        this.einstellungenBearbeiten();
    }

    void buttonAktualisieren_actionPerformed(ActionEvent actionEvent) {
        this.simulate();
    }

    void buttonExport_actionPerformed(ActionEvent actionEvent) {
        block12: {
            Object object;
            File file;
            block11: {
                file = ((MainFrame)this.simulation.getModel().getFrame()).showCSVSave(this);
                if (file != null) break block11;
                Message.write("Export abgebrochen");
                break block12;
            }
            boolean bl = true;
            if (file.exists()) {
                object = new MessageDialog(this.simulation.getModel().getFrame(), "Datei \u00fcberschreiben?", true);
                ((MessageDialog)object).show("Die Datei " + file.getName() + " existiert bereits.\nWollen sie die Datei \u00fcberschreiben?", "Datei NICHT \u00fcberschreiben", null, "Datei \u00fcberschreiben");
                if (((MessageDialog)object).getAnswer() != 2) {
                    bl = false;
                    Message.write("Export abgebrochen. Datei " + file.getName() + " wurde nicht \u00fcberschrieben");
                } else {
                    Message.write("Datei " + file.getName() + " wird \u00fcberschrieben");
                }
            }
            if (!bl) break block12;
            object = new int[this.jTable1.getColumnCount()];
            int n = 0;
            while (n < ((int[])object).length) {
                object[n] = this.jTable1.getColumnModel().getColumn(n).getModelIndex();
                ++n;
            }
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                int n2 = 0;
                while (n2 < ((Object)object).length) {
                    dataOutputStream.writeBytes("\"" + this.jTable1.getModel().getColumnName((int)object[n2]) + "\"");
                    if (n2 < ((Object)object).length - 1) {
                        dataOutputStream.writeBytes(";");
                    }
                    ++n2;
                }
                dataOutputStream.writeBytes("\n");
                int n3 = 0;
                while (n3 < this.jTable1.getRowCount()) {
                    int n4 = 0;
                    while (n4 < ((Object)object).length) {
                        dataOutputStream.writeBytes(this.jTable1.getValueAt(n3, n4).toString());
                        if (n4 < ((Object)object).length - 1) {
                            dataOutputStream.writeBytes(";");
                        }
                        ++n4;
                    }
                    dataOutputStream.writeBytes("\n");
                    ++n3;
                }
                dataOutputStream.close();
                Message.write("Export nach " + file.getName() + " durchgef\u00fchrt");
            }
            catch (Exception exception) {
                Message.write("ERROR: Export nach " + file.getName() + " fehlgeschlagen");
                Message.write("  Meldung: " + exception.getMessage());
            }
        }
    }
}

