/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.graphic;

import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.graphic.ConnectionCreationPanel;
import frei_benno.dynamic.model.graphic.EConnectionPanel;
import frei_benno.dynamic.model.graphic.ModelElementPanel_this_mouseAdapter;
import frei_benno.dynamic.model.graphic.ModelElementPanel_this_mouseMotionAdapter;
import frei_benno.dynamic.model.graphic.ModelPanelInside;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public abstract class ModelElementPanel
extends JPanel {
    public static final int RAND_HORZ = 4;
    public static final int RAND_VERT = 4;
    public static final int RAND_KNOTEN = 5;
    BorderLayout borderLayout1 = new BorderLayout();
    protected ModelElement me;
    protected ModelPanelInside mpi;
    private ConnectionCreationPanel ccp;
    protected int mouseX;
    protected int mouseY;
    protected boolean dragging = false;

    public ModelElementPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setOpaque(false);
        this.addMouseMotionListener(new ModelElementPanel_this_mouseMotionAdapter(this));
        this.addMouseListener(new ModelElementPanel_this_mouseAdapter(this));
        this.setLayout(this.borderLayout1);
    }

    public void setModelElement(ModelElement modelElement) {
        this.me = modelElement;
        this.setPreferredSize(new Dimension((int)(modelElement.getWidth() + 8.0 + 1.0), (int)(modelElement.getHeight() + 8.0 + 1.0)));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.setSize(this.getPreferredSize());
    }

    public ModelElement getModelElement() {
        return this.me;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.me.isMarked()) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, 5, 5);
            graphics.fillRect(this.getWidth() - 5, this.getHeight() - 5, 5, 5);
            graphics.fillRect(0, this.getHeight() - 5, 5, 5);
            graphics.fillRect(this.getWidth() - 5, 0, 5, 5);
            graphics.drawRect(2, 2, this.getWidth() - 5, this.getHeight() - 5);
        }
    }

    protected abstract void myMouseEntered(MouseEvent var1);

    protected abstract void myMouseExited(MouseEvent var1);

    protected abstract void myMouseClicked(MouseEvent var1);

    protected abstract void myMousePressed(MouseEvent var1);

    protected abstract void myMouseDragged(MouseEvent var1);

    protected abstract void myMouseReleased(MouseEvent var1);

    protected abstract void myMouseMoved(MouseEvent var1);

    void this_mouseEntered(MouseEvent mouseEvent) {
        this.me.setMouseOverColor(true);
        this.repaint();
        switch (this.me.getModel().getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        this.me.setMouseOverColor(false);
        this.repaint();
        switch (this.me.getModel().getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseClicked(MouseEvent mouseEvent) {
        switch (this.me.getModel().getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (mouseEvent.getButton() == 1 && (mouseEvent.getModifiers() & 2) != 0) {
                    this.me.toggleMarked();
                } else {
                    this.me.setExclusiveMarked();
                }
                if (mouseEvent.getClickCount() >= 2) {
                    if (mouseEvent.getButton() == 1) {
                        this.myMouseClicked(mouseEvent);
                    }
                }
                this.repaint();
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                this.me.kill();
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        switch (this.me.getModel().getTool()) {
            case 2: {
                if (this instanceof EConnectionPanel) break;
                this.mouseX = this.getX() + mouseEvent.getX();
                this.mouseY = this.getY() + mouseEvent.getY();
                this.ccp = ((ModelPanelInside)this.getParent()).startConnectionCreation();
                this.ccp.setStartPoint(new Point2D.Double((double)this.getX() + (double)mouseEvent.getX(), (double)this.getY() + (double)mouseEvent.getY()));
                this.ccp.setStopPoint(new Point2D.Double((double)this.getX() + (double)mouseEvent.getX() + 1.0, (double)this.getY() + (double)mouseEvent.getY() + 1.0));
                break;
            }
            case 4: {
                this.myMousePressed(mouseEvent);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (mouseEvent.isPopupTrigger()) {
                    this.popItUp(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                this.mouseX = mouseEvent.getX();
                this.mouseY = mouseEvent.getY();
                break;
            }
            case 6: {
                this.me.setExclusiveMarked();
                this.mouseX = mouseEvent.getX();
                this.mouseY = mouseEvent.getY();
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        switch (this.me.getModel().getTool()) {
            case 2: {
                if (this.ccp == null) break;
                this.ccp.setStopPoint(new Point2D.Double((double)this.getX() + (double)mouseEvent.getX(), (double)this.getY() + (double)mouseEvent.getY()));
                break;
            }
            case 4: {
                this.myMouseDragged(mouseEvent);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (!this.dragging) {
                    if (!this.me.isMarked()) {
                        if ((mouseEvent.getModifiers() & 2) != 0) {
                            this.me.setAdditionalMarked();
                        } else {
                            this.me.setExclusiveMarked();
                        }
                    }
                    this.dragging = true;
                }
                this.me.getModel().moveMarkedPanels(mouseEvent.getX() - this.mouseX, mouseEvent.getY() - this.mouseY);
                break;
            }
            case 6: {
                if (!this.dragging) {
                    this.dragging = true;
                }
                this.me.getModel().moveMarkedPanels(mouseEvent.getX() - this.mouseX, mouseEvent.getY() - this.mouseY);
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        switch (this.me.getModel().getTool()) {
            case 2: {
                if (this.ccp == null) break;
                ((ModelPanelInside)this.getParent()).stopConnectionCreation(mouseEvent.getX(), mouseEvent.getY());
                this.ccp = null;
                break;
            }
            case 4: {
                this.myMouseReleased(mouseEvent);
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (this.dragging) {
                    this.dragging = false;
                    this.me.getModel().confirmMovingPanels();
                    this.getParent().repaint();
                    break;
                }
                if (!mouseEvent.isPopupTrigger()) break;
                this.popItUp(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 6: {
                if (this.dragging) {
                    this.dragging = false;
                    this.me.getModel().confirmMovingPanels();
                    this.getParent().repaint();
                }
                this.me.getModel().removeMarks();
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        switch (this.me.getModel().getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    public void moveMe(int n, int n2) {
        this.setLocation(this.getX() + n, this.getY() + n2);
        this.me.move(n, n2);
    }

    public void confirmMoving() {
        this.me.confirmMoving();
    }

    public void removeMe() {
        this.getParent().remove(this);
    }

    public void setPosition(double d, double d2) {
        this.setLocation((int)(d - 4.0), (int)(d2 - 4.0));
    }

    public abstract void popItUp(int var1, int var2);
}

