/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.graphic;

import frei_benno.dynamic.model.EIntermediateValue;
import frei_benno.dynamic.model.Graphic;
import frei_benno.dynamic.model.array.SimulationArray;
import frei_benno.dynamic.model.graphic.ConstantVariationDialog;
import frei_benno.dynamic.model.graphic.GraphicPanelInside;
import frei_benno.dynamic.model.graphic.GraphicPanel_buttonFitSize_actionAdapter;
import frei_benno.dynamic.model.graphic.GraphicPanel_buttonKonstVar_actionAdapter;
import frei_benno.dynamic.model.graphic.GraphicPanel_buttonProps_actionAdapter;
import frei_benno.dynamic.model.graphic.GraphicPanel_buttonRefresh_actionAdapter;
import frei_benno.dynamic.model.graphic.GraphicPanel_gpi_componentAdapter;
import frei_benno.dynamic.model.graphic.GraphicPanel_this_componentAdapter;
import frei_benno.dynamic.model.graphic.GraphicPropertyDialog;
import frei_benno.dynamic.toolkit.IconGetter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class GraphicPanel
extends JPanel {
    private Graphic graphic;
    private Icon iconProperties = IconGetter.getIcon("/frei_benno/dynamic/images/iconEinstellungen.gif");
    private Icon iconRefresh = IconGetter.getIcon("/frei_benno/dynamic/images/iconAktualisieren.gif");
    private Icon iconFitSize = IconGetter.getIcon("/frei_benno/dynamic/images/iconFitSize.gif");
    private Icon iconKonstVar = IconGetter.getIcon("/frei_benno/dynamic/images/iconKonstVar.gif");
    BorderLayout borderLayout1 = new BorderLayout();
    JToolBar jToolBar1 = new JToolBar();
    JButton buttonProps = new JButton();
    GraphicPanelInside gpi = new GraphicPanelInside();
    JButton buttonRefresh = new JButton();
    JButton buttonFitSize = new JButton();
    JButton buttonKonstVar = new JButton();
    SimulationArray sims;

    public GraphicPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void copyContent() {
        this.graphic.copyContent(this);
    }

    public void printContent() {
        this.graphic.printContent();
    }

    public String getName() {
        if (this.graphic != null) {
            return this.graphic.getId().getName();
        }
        return "XXX";
    }

    public void setName(String string) {
        if (this.graphic != null) {
            this.graphic.getId().setName(string);
        }
    }

    public void setGraphic(Graphic graphic) {
        this.graphic = graphic;
        this.gpi.setGraphic(graphic);
        if (this.graphic.getModelFile() != null) {
            this.buttonKonstVar.setEnabled(false);
            this.buttonKonstVar.setVisible(false);
        }
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.buttonProps.addActionListener(new GraphicPanel_buttonProps_actionAdapter(this));
        this.jToolBar1.setFloatable(false);
        this.setDoubleBuffered(false);
        this.addComponentListener(new GraphicPanel_this_componentAdapter(this));
        this.gpi.addComponentListener(new GraphicPanel_gpi_componentAdapter(this));
        this.buttonRefresh.addActionListener(new GraphicPanel_buttonRefresh_actionAdapter(this));
        this.buttonProps.setMaximumSize(new Dimension(20, 20));
        this.buttonProps.setMinimumSize(new Dimension(20, 20));
        this.buttonProps.setPreferredSize(new Dimension(20, 20));
        this.buttonProps.setMargin(new Insets(2, 2, 2, 2));
        this.buttonProps.setText("");
        this.buttonRefresh.setMaximumSize(new Dimension(20, 20));
        this.buttonRefresh.setMinimumSize(new Dimension(20, 20));
        this.buttonRefresh.setPreferredSize(new Dimension(20, 20));
        this.buttonRefresh.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRefresh.setText("");
        this.buttonRefresh.addActionListener(new GraphicPanel_buttonRefresh_actionAdapter(this));
        this.buttonFitSize.setToolTipText("Gr\u00f6sse anpassen");
        this.buttonFitSize.setIcon(this.iconFitSize);
        this.buttonFitSize.addActionListener(new GraphicPanel_buttonFitSize_actionAdapter(this));
        this.buttonFitSize.setText("");
        this.buttonFitSize.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFitSize.setPreferredSize(new Dimension(20, 20));
        this.buttonFitSize.setMinimumSize(new Dimension(20, 20));
        this.buttonFitSize.setMaximumSize(new Dimension(20, 20));
        this.buttonFitSize.addActionListener(new GraphicPanel_buttonFitSize_actionAdapter(this));
        this.buttonKonstVar.setMaximumSize(new Dimension(20, 20));
        this.buttonKonstVar.setMinimumSize(new Dimension(20, 20));
        this.buttonKonstVar.setPreferredSize(new Dimension(20, 20));
        this.buttonKonstVar.setMargin(new Insets(2, 2, 2, 2));
        this.buttonKonstVar.setText("");
        this.buttonKonstVar.addActionListener(new GraphicPanel_buttonKonstVar_actionAdapter(this));
        this.add((Component)this.jToolBar1, "North");
        this.jToolBar1.add((Component)this.buttonProps, null);
        this.jToolBar1.add((Component)this.buttonRefresh, null);
        this.jToolBar1.add((Component)this.buttonFitSize, null);
        this.jToolBar1.add((Component)this.buttonKonstVar, null);
        this.add(this.gpi);
        this.buttonProps.setIcon(this.iconProperties);
        this.buttonProps.setToolTipText("Einstellungen");
        this.buttonRefresh.setIcon(this.iconRefresh);
        this.buttonRefresh.setToolTipText("Aktualisieren");
        this.buttonKonstVar.setIcon(this.iconKonstVar);
        this.buttonKonstVar.setToolTipText("Konstanten variieren");
    }

    public void einstellungenBearbeiten() {
        new GraphicPropertyDialog((Frame)this.graphic.getFrame(), "Einstellungen", true, this.graphic).show();
        this.graphic.recalculateCoordinates();
        Container container = this.getParent();
        if (container != null && container instanceof JTabbedPane) {
            ((JTabbedPane)container).setTitleAt(((JTabbedPane)container).getSelectedIndex(), this.graphic.getId().getName());
        }
        this.repaint();
    }

    void buttonProps_actionPerformed(ActionEvent actionEvent) {
        this.einstellungenBearbeiten();
    }

    void this_componentShown(ComponentEvent componentEvent) {
        this.gpi.resized();
    }

    void buttonRefresh_actionPerformed(ActionEvent actionEvent) {
        this.graphic.reload();
        this.repaint();
    }

    void buttonFitSize_actionPerformed(ActionEvent actionEvent) {
        this.graphic.reload();
        this.graphic.initialCalculation();
        this.repaint();
    }

    void buttonKonstVar_actionPerformed(ActionEvent actionEvent) {
        this.sims = this.graphic.getLineArray().getAllSimulations();
        EIntermediateValue[] eIntermediateValueArray = this.graphic.getModelFolder().getModel().getConstants();
        int n = 0;
        while (n < eIntermediateValueArray.length) {
            ConstantVariationDialog constantVariationDialog = new ConstantVariationDialog(this.graphic.getFrame(), "JA", false);
            constantVariationDialog.setModelFolder(this.graphic.getModelFolder());
            constantVariationDialog.setGraphicPanel(this);
            constantVariationDialog.setIntermediateValue(eIntermediateValueArray[n]);
            constantVariationDialog.show();
            ++n;
        }
    }

    public void reSimulate() {
        if (this.sims != null) {
            this.sims.simulateAll();
        }
        this.graphic.reload();
        this.repaint();
    }
}

