/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.ModelElementValue;
import frei_benno.dynamic.model.graphic.EStatePanel;
import frei_benno.dynamic.model.graphic.ModelElementPanel;
import frei_benno.dynamic.toolkit.ArcCalculator;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EState
extends ModelElementValue
implements IDrawable2D {
    public static final double STATE_WIDTH = 50.0;
    public static final double STATE_HEIGHT = 30.0;
    private double startValue = 0.0;
    private boolean valueSet = false;
    private double flowingValue = 0.0;
    private double gradient = 0.0;

    public EState(Model model) {
        super(model);
        this.setWidth(50.0);
        this.setHeight(30.0);
        this.setValid(false);
    }

    public double getWidth() {
        return 50.0;
    }

    public double getHeight() {
        return 30.0;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public void setStartValue(double d) {
        this.startValue = d;
        this.setValid(true);
        this.valueSet = true;
    }

    protected ModelElementPanel constructSpecificPanel() {
        return new EStatePanel();
    }

    public Point2D.Double getConnectionPoint2D(Point2D.Double double_) {
        return ArcCalculator.getRectLineIntersection(this.loc, double_);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        graphics2D.setColor(ModelElement.backgroundColor);
        graphics2D.fill(this.loc);
        if (this.mouseOver) {
            graphics2D.setColor(ModelElement.mouseOverColor);
        } else {
            graphics2D.setColor(ModelElement.standardColor);
        }
        graphics2D.draw(this.loc);
        graphics2D.setFont(ModelElement.standardFont);
        graphics2D.setColor(ModelElement.fontColor);
        graphics2D.drawString(this.id.getName(), (float)(this.getCentreX() - (double)(graphics2D.getFontMetrics().stringWidth(this.id.getName()) / 2)), (float)(this.loc.y + 30.0 + 1.0 + 12.0));
        if (!this.isValid()) {
            this.drawInvalidSymbol(graphics2D, this.centre);
        }
    }

    public boolean getValueSet() {
        return this.valueSet;
    }

    public void removeUsers() {
        super.removeUsers();
        this.getModel().getFlowArray().checkForRemoving(this.id);
    }

    public void doValidation() {
        if (this.valueSet) {
            this.setValid(true);
        } else {
            this.setValid(false);
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        dataOutputStream.writeBoolean(this.valueSet);
        dataOutputStream.writeDouble(this.startValue);
        dataOutputStream.writeDouble(this.loc.x);
        dataOutputStream.writeDouble(this.loc.y);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.id = this.model.getModelFolder().getIdHandler().loadId(n, this);
        this.valueSet = dataInputStream.readBoolean();
        this.startValue = dataInputStream.readDouble();
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        this.setPosition(d, d2);
    }

    public void inGradient(double d) {
        this.gradient += d;
    }

    public void outGradient(double d) {
        this.gradient -= d;
    }

    public void resetGradient() {
        this.gradient = 0.0;
    }

    public double getGradient() {
        return this.gradient;
    }

    public void inFlow(double d) {
        this.flowingValue += d;
    }

    public void outFlow(double d) {
        this.flowingValue -= d;
    }

    public void approveFlows() {
        this.value += this.flowingValue;
        this.flowingValue = 0.0;
    }

    public void resetFlows() {
        this.flowingValue = 0.0;
    }
}

