/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.math;

import frei_benno.dynamic.formula.math.Function;
import frei_benno.dynamic.formula.math.IFunction;

public abstract class Function1
extends Function {
    protected double lasttermval;
    protected double lastownval;
    protected IFunction term;
    protected boolean initialized;

    public Function1() {
        this(null);
    }

    public Function1(IFunction iFunction) {
        this.term = iFunction;
        this.lastownval = 0.0;
        this.lasttermval = 0.0;
        this.initialized = false;
    }

    public void setTerm(IFunction iFunction) {
        this.term = iFunction;
        this.lastownval = 0.0;
        this.lasttermval = 0.0;
        this.initialized = false;
    }

    public double eval() {
        if (this.term != null) {
            double d = this.term.eval();
            if (!this.initialized || d != this.lasttermval) {
                this.initialized = true;
                this.lasttermval = d;
                this.lastownval = this.operation(this.lasttermval);
                if (Double.isInfinite(this.lastownval)) {
                    // empty if block
                }
                if (Double.isNaN(this.lastownval)) {
                    // empty if block
                }
            }
            return this.lastownval;
        }
        return 0.0;
    }

    protected abstract double operation(double var1);

    public String writeFunction() {
        return this.className() + "(" + this.term.writeFunction() + ")";
    }
}

