/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.math;

import frei_benno.dynamic.formula.math.Function2;
import java.util.Random;

public class FRandom
extends Function2 {
    private static Random random = new Random(System.currentTimeMillis());
    private static final String[] options = new String[]{"Random()", "Random(gr\u00f6sster Wert)", "Random(kleinster Wert; gr\u00f6sster Wert)"};

    public FRandom() {
        this.initialized = true;
    }

    public FRandom(long l) {
        this();
        random = new Random(l);
    }

    protected double operation(double d, double d2) {
        if (d > d2) {
            return random.nextDouble() * (d - d2) + d2;
        }
        if (d < d2) {
            return random.nextDouble() * (d2 - d) + d;
        }
        return d;
    }

    public double eval() {
        if (this.term1 != null && this.term2 != null) {
            return this.operation(this.term1.eval(), this.term2.eval());
        }
        return 0.0;
    }

    public String className() {
        return "FRandom";
    }

    public String toString() {
        return "Random";
    }

    public String[] getOptions() {
        return options;
    }
}

