/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.graphic;

import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.graphic.ConnectionCreationPanel;
import frei_benno.dynamic.model.graphic.EStatePanel;
import frei_benno.dynamic.model.graphic.FlowCreationPanel;
import frei_benno.dynamic.model.graphic.MarkerPanel;
import frei_benno.dynamic.model.graphic.ModelElementPanel;
import frei_benno.dynamic.model.graphic.ModelPanelInside_popupNewInter_actionAdapter;
import frei_benno.dynamic.model.graphic.ModelPanelInside_popupNewState_actionAdapter;
import frei_benno.dynamic.model.graphic.ModelPanelInside_this_mouseAdapter;
import frei_benno.dynamic.model.graphic.ModelPanelInside_this_mouseMotionAdapter;
import frei_benno.dynamic.toolkit.CursorGetter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ModelPanelInside
extends JPanel {
    private Cursor cursorMouse = new Cursor(0);
    private Cursor cursorState = CursorGetter.loadCursor("/frei_benno/dynamic/images/statemouse.gif", 10, 10, "STATE_CURSOR");
    private Cursor cursorFlow = CursorGetter.loadCursor("/frei_benno/dynamic/images/flowmouse.gif", 10, 14, "FLOW_CURSOR");
    private Cursor cursorInter = CursorGetter.loadCursor("/frei_benno/dynamic/images/intermouse.gif", 10, 10, "INTER_CURSOR");
    private Cursor cursorConn = CursorGetter.loadCursor("/frei_benno/dynamic/images/connectionmouse.gif", 17, 6, "CONN_CURSOR");
    private Cursor cursorRubber = CursorGetter.loadCursor("/frei_benno/dynamic/images/rubbermouse.gif", 3, 15, "RUBBER_CURSOR");
    private Cursor cursorMover = CursorGetter.loadCursor("/frei_benno/dynamic/images/movermouse.gif", 11, 11, "MOVER_CURSOR");
    private Model model;
    private int myWidth = 100;
    private int myHeight = 100;
    JPopupMenu popupModelStandard = new JPopupMenu();
    JMenuItem popupNewState = new JMenuItem();
    JMenuItem popupNewFlow = new JMenuItem();
    JMenuItem popupNewInter = new JMenuItem();
    JMenuItem popupNewConnection = new JMenuItem();
    private int mouseX;
    private int mouseY;
    private ConnectionCreationPanel ccp = new ConnectionCreationPanel();
    private FlowCreationPanel fcp = new FlowCreationPanel();
    private MarkerPanel markerPanel = new MarkerPanel();
    private int lastTool = 0;

    public ModelPanelInside() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(null);
        this.popupNewState.setText("Neu State");
        this.popupNewState.addActionListener(new ModelPanelInside_popupNewState_actionAdapter(this));
        this.popupNewFlow.setText("Neu Fluss");
        this.popupNewInter.setText("Neu Zwischenwert");
        this.popupNewInter.addActionListener(new ModelPanelInside_popupNewInter_actionAdapter(this));
        this.popupNewConnection.setText("Neu Verbindung");
        this.addMouseListener(new ModelPanelInside_this_mouseAdapter(this));
        this.addMouseMotionListener(new ModelPanelInside_this_mouseMotionAdapter(this));
        this.popupModelStandard.add(this.popupNewState);
        this.popupModelStandard.add(this.popupNewFlow);
        this.popupModelStandard.add(this.popupNewInter);
        this.popupModelStandard.add(this.popupNewConnection);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.myWidth, this.myHeight);
    }

    public void setModel(Model model) {
        this.model = model;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.model != null) {
            this.model.draw2D((Graphics2D)graphics, this);
        }
    }

    public FlowCreationPanel startFlowCreation(int n, int n2) {
        this.add(this.fcp);
        this.fcp.setStartPoint(new Point2D.Double(n, n2));
        this.fcp.setStopPoint(new Point2D.Double((double)n + 1.0, (double)n2 + 1.0));
        this.fcp.setVisible(true);
        return this.fcp;
    }

    public void moveFlowCreation(int n, int n2) {
        this.fcp.setStopPoint(new Point2D.Double(n, n2));
    }

    public void stopFlowCreation(int n, int n2) {
        this.remove(this.fcp);
        Component component = this.getComponentAt((int)this.fcp.getStartX(), (int)this.fcp.getStartY());
        Component component2 = this.getComponentAt((int)this.fcp.getStopX(), (int)this.fcp.getStopY());
        if (!(component instanceof EStatePanel) && !(component instanceof ModelPanelInside) || !(component2 instanceof EStatePanel) && !(component2 instanceof ModelPanelInside)) {
            Message.write("FLUSS NUR MIT STATE ODER UMWELT VERBINDEN!!!");
        } else if (component instanceof ModelPanelInside && component2 instanceof ModelPanelInside) {
            Message.write("EIN FLUSS MUSS MIT MINDESTENS EINEM STATE VERBUNDEN SEIN");
        } else {
            ModelElement modelElement = component instanceof EStatePanel ? ((EStatePanel)component).getModelElement() : null;
            ModelElement modelElement2 = component2 instanceof EStatePanel ? ((EStatePanel)component2).getModelElement() : null;
            this.model.putNewFlow(modelElement == null ? null : modelElement.getId(), modelElement2 == null ? null : modelElement2.getId(), new Point2D.Double(modelElement == null ? this.fcp.getStartX() : modelElement.getCentreX(), modelElement == null ? this.fcp.getStartY() : modelElement.getCentreY()), new Point2D.Double(modelElement2 == null ? this.fcp.getStopX() : modelElement2.getCentreX(), modelElement2 == null ? this.fcp.getStopY() : modelElement2.getCentreY()));
        }
        this.repaint();
    }

    public ConnectionCreationPanel startConnectionCreation() {
        this.add(this.ccp);
        return this.ccp;
    }

    public void stopConnectionCreation(int n, int n2) {
        this.remove(this.ccp);
        Component component = this.getComponentAt((int)this.ccp.getStartX(), (int)this.ccp.getStartY());
        Component component2 = this.getComponentAt((int)this.ccp.getStopX(), (int)this.ccp.getStopY());
        if (!(component instanceof ModelPanelInside) && !(component2 instanceof ModelPanelInside) && component != null && component2 != null) {
            this.model.putNewConnection(((ModelElementPanel)component).me, ((ModelElementPanel)component2).me);
        }
        this.repaint();
    }

    void this_mousePressed(MouseEvent mouseEvent) {
        switch (this.model.getTool()) {
            case 2: {
                break;
            }
            case 4: {
                this.startFlowCreation(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (mouseEvent.isPopupTrigger()) {
                    this.mouseX = mouseEvent.getX();
                    this.mouseY = mouseEvent.getY();
                    this.popupModelStandard.show(this, this.mouseX, this.mouseY);
                }
                if (mouseEvent.getButton() != 1) break;
                if ((mouseEvent.getModifiers() & 2) == 0) {
                    this.model.removeMarks();
                }
                this.mouseX = mouseEvent.getX();
                this.mouseY = mouseEvent.getY();
                this.markerPanel.setVisible(false);
                this.add(this.markerPanel);
                this.markerPanel.setLocation(this.mouseX, this.mouseY);
                this.markerPanel.setSize(1, 1);
                this.markerPanel.setVisible(true);
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        switch (this.model.getTool()) {
            case 2: {
                break;
            }
            case 4: {
                this.moveFlowCreation(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this.markerPanel.setLocation(this.mouseX < mouseEvent.getX() ? this.mouseX : mouseEvent.getX(), this.mouseY < mouseEvent.getY() ? this.mouseY : mouseEvent.getY());
                this.markerPanel.setSize(Math.abs(this.mouseX - mouseEvent.getX()), Math.abs(this.mouseY - mouseEvent.getY()));
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mouseX = mouseEvent.getX();
            this.mouseY = mouseEvent.getY();
            this.popupModelStandard.show(this, this.mouseX, this.mouseY);
        }
        switch (this.model.getTool()) {
            case 2: {
                break;
            }
            case 4: {
                this.stopFlowCreation(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (mouseEvent.getButton() != 1) break;
                this.markerPanel.setVisible(false);
                this.remove(this.markerPanel);
                Rectangle rectangle = this.markerPanel.getBounds();
                Component[] componentArray = this.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    if (rectangle.intersects(componentArray[n].getBounds())) {
                        ((ModelElementPanel)componentArray[n]).me.setMarked(true);
                    }
                    ++n;
                }
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseClicked(MouseEvent mouseEvent) {
        this.model.removeMarks();
        switch (this.model.getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                if (mouseEvent.getButton() != 1) break;
                this.model.putNewIntermediateValue(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                if (mouseEvent.getButton() != 1) break;
                this.model.putNewState(mouseEvent.getX(), mouseEvent.getY());
                break;
            }
        }
    }

    void this_mouseEntered(MouseEvent mouseEvent) {
        this.setMyCursor();
        switch (this.model.getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseExited(MouseEvent mouseEvent) {
        switch (this.model.getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void this_mouseMoved(MouseEvent mouseEvent) {
        switch (this.model.getTool()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                break;
            }
        }
    }

    void popupNewState_actionPerformed(ActionEvent actionEvent) {
        this.model.putNewState(this.mouseX, this.mouseY);
    }

    void popupNewInter_actionPerformed(ActionEvent actionEvent) {
        this.model.putNewIntermediateValue(this.mouseX, this.mouseY);
    }

    public void setMyCursor() {
        if (this.model.getTool() != this.lastTool) {
            Cursor cursor;
            this.model.removeMarks();
            this.lastTool = this.model.getTool();
            switch (this.model.getTool()) {
                case 2: {
                    cursor = this.cursorConn;
                    break;
                }
                case 4: {
                    cursor = this.cursorFlow;
                    break;
                }
                case 1: {
                    cursor = this.cursorInter;
                    break;
                }
                case 0: {
                    cursor = this.cursorMouse;
                    break;
                }
                case 6: {
                    cursor = this.cursorMover;
                    break;
                }
                case 5: {
                    cursor = this.cursorRubber;
                    break;
                }
                case 3: {
                    cursor = this.cursorState;
                    break;
                }
                default: {
                    cursor = this.cursorMouse;
                }
            }
            this.setCursor(cursor);
        }
    }

    public void checkSize() {
        int n = 100;
        int n2 = 100;
        Component[] componentArray = this.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            int n4 = componentArray[n3].getX() + componentArray[n3].getWidth();
            int n5 = componentArray[n3].getY() + componentArray[n3].getHeight();
            if (n4 > n) {
                n = n4;
            }
            if (n5 > n2) {
                n2 = n5;
            }
            ++n3;
        }
        this.myWidth = n + 50;
        this.myHeight = n2 + 50;
        this.getParent().doLayout();
    }
}

