/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.ModelFolder;
import frei_benno.dynamic.model.Simulation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimulationArray {
    private ModelFolder modelFolder;
    private static final int INITIAL_SIZE = 5;
    private static final int INCREMENT = 5;
    private Simulation[] arr;
    private int arr_size;
    private int arr_pos;

    public SimulationArray(ModelFolder modelFolder) {
        this.modelFolder = modelFolder;
        this.arr_size = 5;
        this.arr_pos = 0;
        this.arr = new Simulation[this.arr_size];
    }

    public boolean isInside(Simulation simulation) {
        boolean bl = false;
        int n = 0;
        while (n < this.arr_pos && !bl) {
            if (this.arr[n] == simulation) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public Simulation[] getAll() {
        Simulation[] simulationArray = new Simulation[this.arr_pos];
        int n = 0;
        while (n < this.arr_pos) {
            simulationArray[n] = this.arr[n];
            ++n;
        }
        return simulationArray;
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        Simulation[] simulationArray = new Simulation[this.arr_size];
        System.arraycopy(this.arr, 0, simulationArray, 0, this.arr_pos);
        this.arr = simulationArray;
    }

    public void addElement(Simulation simulation) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        this.arr[this.arr_pos++] = simulation;
    }

    public int length() {
        return this.arr_pos;
    }

    public Simulation getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public void removeElement(Simulation simulation) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != simulation) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_pos = this.arr_size = dataInputStream.readInt();
        this.arr = new Simulation[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = new Simulation(this.modelFolder.getModel());
            this.arr[n].load(dataInputStream);
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }

    public void simulateAll() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].simulate();
            this.arr[n].refresh();
            ++n;
        }
    }
}

