/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.ModelFile;
import frei_benno.dynamic.model.ModelFolder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ModelFolderArray {
    private ModelFile modelFile;
    private static final int INITIAL_SIZE = 5;
    private static final int INCREMENT = 5;
    private ModelFolder[] arr;
    private int arr_size;
    private int arr_pos;

    public ModelFolderArray(ModelFile modelFile) {
        this.modelFile = modelFile;
        this.arr_size = 5;
        this.arr_pos = 0;
        this.arr = new ModelFolder[this.arr_size];
    }

    public ModelFolder[] getAll() {
        ModelFolder[] modelFolderArray = new ModelFolder[this.arr_pos];
        int n = 0;
        while (n < this.arr_pos) {
            modelFolderArray[n] = this.arr[n];
            ++n;
        }
        return modelFolderArray;
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        ModelFolder[] modelFolderArray = new ModelFolder[this.arr_size];
        System.arraycopy(this.arr, 0, modelFolderArray, 0, this.arr_pos);
        this.arr = modelFolderArray;
    }

    public void addElement(ModelFolder modelFolder) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        this.arr[this.arr_pos++] = modelFolder;
    }

    public int length() {
        return this.arr_pos;
    }

    public ModelFolder getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public void removeElement(ModelFolder modelFolder) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != modelFolder) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            int n2 = n;
            while (n2 < this.arr_pos - 1) {
                this.arr[n2] = this.arr[n2 + 1];
                ++n2;
            }
            --this.arr_pos;
            this.arr[this.arr_pos] = null;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_pos = this.arr_size = dataInputStream.readInt();
        this.arr = new ModelFolder[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = new ModelFolder(this.modelFile);
            this.arr[n].load(dataInputStream);
            this.arr[n].simulateAll();
            this.arr[n].reloadAllGraphics();
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }
}

