/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.Graphic;
import frei_benno.dynamic.model.ModelFile;
import frei_benno.dynamic.model.ModelFolder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GraphicArray {
    private ModelFolder modelFolder;
    private ModelFile modelFile;
    private static final int INITIAL_SIZE = 5;
    private static final int INCREMENT = 5;
    private Graphic[] arr;
    private int arr_size;
    private int arr_pos;

    public GraphicArray(ModelFolder modelFolder) {
        this.modelFolder = modelFolder;
        this.arr_size = 5;
        this.arr_pos = 0;
        this.arr = new Graphic[this.arr_size];
    }

    public void reloadAll() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].reload();
            ++n;
        }
    }

    public GraphicArray(ModelFile modelFile) {
        this.modelFile = modelFile;
        this.arr_size = 5;
        this.arr_pos = 0;
        this.arr = new Graphic[this.arr_size];
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        Graphic[] graphicArray = new Graphic[this.arr_size];
        System.arraycopy(this.arr, 0, graphicArray, 0, this.arr_pos);
        this.arr = graphicArray;
    }

    public void addElement(Graphic graphic) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        this.arr[this.arr_pos++] = graphic;
    }

    public int length() {
        return this.arr_pos;
    }

    public Graphic getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public void removeElement(Graphic graphic) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != graphic) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_pos = this.arr_size = dataInputStream.readInt();
        this.arr = new Graphic[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = this.modelFile != null ? new Graphic(this.modelFile) : new Graphic(this.modelFolder);
            this.arr[n].load(dataInputStream);
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }
}

