/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.graphic.ModelElementPanel;

public class ModelElementPanelArray {
    public static final int INITIAL_SIZE = 10;
    public static final int INCREMENT = 10;
    private ModelElementPanel[] arr = new ModelElementPanel[this.arr_size];
    private int arr_size = 10;
    private int arr_pos = 0;

    private void incrementArraySize() {
        this.arr_size += 10;
        ModelElementPanel[] modelElementPanelArray = new ModelElementPanel[this.arr_size];
        System.arraycopy(this.arr, 0, modelElementPanelArray, 0, this.arr_pos);
        this.arr = modelElementPanelArray;
    }

    public void addElement(ModelElementPanel modelElementPanel) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        this.arr[this.arr_pos++] = modelElementPanel;
    }

    public ModelElementPanel getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public int length() {
        return this.arr_pos;
    }

    public void removeElement(ModelElementPanel modelElementPanel) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != modelElementPanel) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void moveAll(int n, int n2) {
        int n3 = 0;
        while (n3 < this.arr_pos) {
            this.arr[n3].moveMe(n, n2);
            ++n3;
        }
    }

    public void confirmAll() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].confirmMoving();
            ++n;
        }
    }

    public void clear() {
        this.arr_pos = 0;
    }
}

