/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.Graphic;
import frei_benno.dynamic.model.Line;
import frei_benno.dynamic.model.LineProperties;
import frei_benno.dynamic.model.Simulation;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class PhaseLine
extends Line {
    private Graphic graphic;
    private IDElement id;
    private IDElement simIdX;
    private IDElement simIdY;
    private IDElement eleIdX;
    private IDElement eleIdY;
    private double[] valuesX;
    private double[] valuesY;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private GeneralPath gp;
    private LineProperties lineProperties;
    private Shape drawingLine;
    private int ca_pos;

    public PhaseLine(Graphic graphic, IDElement iDElement, IDElement iDElement2, IDElement iDElement3, IDElement iDElement4) {
        block2: {
            this.gp = new GeneralPath();
            this.lineProperties = new LineProperties();
            this.ca_pos = 0;
            this.graphic = graphic;
            this.id = graphic.getIdHandler().createNewID("LINIE", this);
            this.simIdX = iDElement;
            this.eleIdX = iDElement2;
            this.simIdY = iDElement3;
            this.eleIdY = iDElement4;
            if (iDElement == null || iDElement2 == null || iDElement3 == null || iDElement4 == null) break block2;
            try {
                this.reloadData();
            }
            catch (Exception exception) {}
        }
    }

    public float drawLegende(Graphics2D graphics2D, float f, float f2, float f3) {
        AffineTransform affineTransform;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("sansserif", 0, 12);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.setLength(0);
        stringBuffer.append("Phase: ");
        TextLayout textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        if (rectangle2D.getMaxX() - rectangle2D.getMinX() > (double)f2) {
            affineTransform = new AffineTransform();
            affineTransform.scale((double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()), (double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()));
            font = font.deriveFont(affineTransform);
            textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
        }
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, f, f3 - (float)rectangle2D.getMinY());
        f3 += (float)(rectangle2D.getMaxY() - rectangle2D.getMinY()) + 10.0f;
        stringBuffer.setLength(0);
        stringBuffer.append("X: ");
        stringBuffer.append(this.simIdX.getName());
        stringBuffer.append(".");
        stringBuffer.append(this.eleIdX.getName());
        textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
        rectangle2D = textLayout.getBounds();
        if (rectangle2D.getMaxX() - rectangle2D.getMinX() > (double)f2) {
            affineTransform = new AffineTransform();
            affineTransform.scale((double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()), (double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()));
            font = font.deriveFont(affineTransform);
            textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
        }
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, f, f3 - (float)rectangle2D.getMinY());
        f3 += (float)(rectangle2D.getMaxY() - rectangle2D.getMinY()) + 10.0f;
        stringBuffer.setLength(0);
        stringBuffer.append("Y: ");
        stringBuffer.append(this.simIdY.getName());
        stringBuffer.append(".");
        stringBuffer.append(this.eleIdY.getName());
        textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
        rectangle2D = textLayout.getBounds();
        if (rectangle2D.getMaxX() - rectangle2D.getMinX() > (double)f2) {
            affineTransform = new AffineTransform();
            affineTransform.scale((double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()), (double)f2 / (rectangle2D.getMaxX() - rectangle2D.getMinX()));
            font = font.deriveFont(affineTransform);
            textLayout = new TextLayout(stringBuffer.toString(), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
        }
        graphics2D.setColor(Color.black);
        textLayout.draw(graphics2D, f, f3 - (float)rectangle2D.getMinY());
        this.lineProperties.prepareGraphics(graphics2D);
        GeneralPath generalPath = new GeneralPath();
        generalPath.reset();
        generalPath.moveTo(f, (f3 += (float)(rectangle2D.getMaxY() - rectangle2D.getMinY())) + 5.0f);
        generalPath.lineTo(f + f2, f3 + 5.0f);
        graphics2D.draw(generalPath);
        this.lineProperties.restoreGraphics(graphics2D);
        return f3 += 10.0f;
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public IDElement getSimulationId() {
        return this.simIdX;
    }

    public IDElement getElementId() {
        return this.eleIdX;
    }

    public IDElement getSimulationIdY() {
        return this.simIdY;
    }

    public IDElement getElementIdY() {
        return this.eleIdY;
    }

    private double getValueAtTime(double[] dArray, double[] dArray2, double d) {
        while (this.ca_pos > 0 && dArray[this.ca_pos] > d) {
            --this.ca_pos;
        }
        while (this.ca_pos + 1 < dArray.length - 1 && dArray[this.ca_pos + 1] < d) {
            ++this.ca_pos;
        }
        return dArray2[this.ca_pos] + (dArray2[this.ca_pos + 1] - dArray2[this.ca_pos]) / (dArray[this.ca_pos + 1] - dArray[this.ca_pos]) * (d - dArray[this.ca_pos]);
    }

    public void reloadData() {
        Simulation simulation = (Simulation)this.simIdX.getOwner();
        Simulation simulation2 = (Simulation)this.simIdY.getOwner();
        double[] dArray = simulation.getTimeAxe();
        double[] dArray2 = simulation2.getTimeAxe();
        double[] dArray3 = simulation.getElementValues(this.eleIdX);
        double[] dArray4 = simulation2.getElementValues(this.eleIdY);
        if (dArray[0] < dArray2[dArray2.length - 1] && dArray2[0] < dArray[dArray.length - 1]) {
            double d = dArray[0] < dArray2[0] ? dArray2[0] : dArray[0];
            double d2 = dArray[dArray.length - 1] < dArray2[dArray2.length - 1] ? dArray[dArray.length - 1] : dArray2[dArray2.length - 1];
            int n = 0;
            while (dArray[n] < d) {
                ++n;
            }
            int n2 = 0;
            while (dArray2[n2] < d) {
                ++n2;
            }
            int n3 = n;
            while (n3 < dArray.length - 1 && dArray[n3 + 1] < d2) {
                ++n3;
            }
            this.valuesX = new double[n3 - n + 1];
            this.valuesY = new double[n3 - n + 1];
            this.minX = Double.POSITIVE_INFINITY;
            this.maxX = Double.NEGATIVE_INFINITY;
            int n4 = 0;
            while (n4 < this.valuesX.length) {
                this.valuesX[n4] = dArray3[n4 + n];
                if (this.valuesX[n4] < this.minX) {
                    this.minX = this.valuesX[n4];
                }
                if (this.valuesX[n4] > this.maxX) {
                    this.maxX = this.valuesX[n4];
                }
                ++n4;
            }
            this.ca_pos = n2 - 1;
            if (this.ca_pos < 0) {
                this.ca_pos = 0;
            }
            this.minY = Double.POSITIVE_INFINITY;
            this.maxY = Double.NEGATIVE_INFINITY;
            int n5 = 0;
            while (n5 < this.valuesY.length) {
                this.valuesY[n5] = this.getValueAtTime(dArray2, dArray4, dArray[n5]);
                if (this.valuesY[n5] < this.minY) {
                    this.minY = this.valuesY[n5];
                }
                if (this.valuesY[n5] > this.maxY) {
                    this.maxY = this.valuesY[n5];
                }
                ++n5;
            }
            this.gp.reset();
            this.gp.moveTo((float)this.valuesX[0], (float)this.valuesY[0]);
            int n6 = 1;
            while (n6 < this.valuesX.length) {
                this.gp.lineTo((float)this.valuesX[n6], (float)this.valuesY[n6]);
                ++n6;
            }
        } else {
            this.minX = 0.0;
            this.minY = 0.0;
            this.maxY = 1.0;
            this.minY = 1.0;
            this.gp.reset();
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(1.0f, 1.0f);
            this.gp.moveTo(0.0f, 1.0f);
            this.gp.lineTo(1.0f, 0.0f);
            Message.write("ERROR: Die beiden ausgew\u00e4hlten Werte haben keine gemeinsame Simulationszeit");
        }
    }

    public double getMinTime() {
        return this.minX;
    }

    public double getMaxTime() {
        return this.maxX;
    }

    public double getMinVal() {
        return this.minY;
    }

    public double getMaxVal() {
        return this.maxY;
    }

    public void recalculateShape(AffineTransform affineTransform) {
        this.drawingLine = this.gp.createTransformedShape(affineTransform);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent, AffineTransform affineTransform) {
        this.lineProperties.prepareGraphics(graphics2D);
        double d = (this.drawingLine.getBounds2D().getMaxY() - this.drawingLine.getBounds2D().getMinY()) / this.graphic.getRectValues().height;
        double d2 = (this.drawingLine.getBounds2D().getMaxX() - this.drawingLine.getBounds2D().getMinX()) / this.graphic.getRectValues().width;
        if (Double.isNaN(d) || Double.isInfinite(d) || d > 1000000.0 || Double.isNaN(d2) || Double.isInfinite(d2) || d2 > 1000000.0) {
            Message.write("Phasenlinie " + this.toString() + " kann nicht mehr " + "dargestellt werden");
        } else {
            graphics2D.draw(this.drawingLine);
        }
        this.lineProperties.restoreGraphics(graphics2D);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.id = this.graphic.getIdHandler().loadId(dataInputStream.readInt(), this);
        this.simIdX = this.graphic.getIdHandler().getIdElement(dataInputStream.readInt());
        this.eleIdX = this.graphic.getIdHandler().getIdElement(dataInputStream.readInt());
        this.simIdY = this.graphic.getIdHandler().getIdElement(dataInputStream.readInt());
        this.eleIdY = this.graphic.getIdHandler().getIdElement(dataInputStream.readInt());
        this.lineProperties.load(dataInputStream);
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        dataOutputStream.writeInt(this.simIdX.getId());
        dataOutputStream.writeInt(this.eleIdX.getId());
        dataOutputStream.writeInt(this.simIdY.getId());
        dataOutputStream.writeInt(this.eleIdY.getId());
        this.lineProperties.save(dataOutputStream);
    }

    public String toString() {
        return "(" + this.simIdX.getName() + "." + this.eleIdX.getName() + "/" + this.simIdY.getName() + "." + this.eleIdY.getName() + ")";
    }

    public LineProperties getLineProperties() {
        return this.lineProperties;
    }
}

