/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.IDrawable;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.array.IElementArray;
import frei_benno.dynamic.model.graphic.ModelElementPanel;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JFrame;

public abstract class ModelElement
implements IDrawable,
IDrawable2D {
    public static final Color backgroundColor = new Color(240, 240, 240);
    public static final Color mouseOverColor = Color.red;
    public static final Color standardColor = Color.blue;
    public static final Color fontColor = Color.black;
    public static final Font standardFont = new Font("Sans-Serif", 1, 12);
    protected Rectangle2D.Double loc;
    protected Point2D.Double pos;
    protected Point2D.Double centre;
    protected boolean marked;
    protected Model model;
    protected IDElement id;
    protected IElementArray arr;
    protected ModelElementPanel mep;
    protected boolean valid = true;
    protected Color colorNormal = Color.blue;
    protected Color colorOver = Color.red;
    protected Color actual_Color = this.colorNormal;
    protected boolean mouseOver = false;
    private Arc2D.Double invalidScheibe = new Arc2D.Double(0.0, 0.0, 20.0, 20.0, 0.0, 360.0, 0);
    private String invalidString = "?";
    private Font invalidFont = new Font("Sans-Serif", 1, 16);
    private Color invalidBackgroundColor = Color.black;
    private Color invalidForegroundColor = Color.white;
    protected int moveX = 0;
    protected int moveY = 0;

    public ModelElement(Model model) {
        this.model = model;
        this.loc = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        this.pos = new Point2D.Double(0.0, 0.0);
        this.centre = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        this.id = model.getModelFolder().getIdHandler().createNewID(this);
        this.mep = this.constructSpecificPanel();
        this.model.getModelPanelInside().add(this.mep);
        this.mep.setModelElement(this);
    }

    public Rectangle2D.Double getTotalLocation() {
        return this.loc;
    }

    public JFrame getFrame() {
        return this.model.getFrame();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public Point2D.Double getLocation() {
        return this.pos;
    }

    public double getX() {
        return this.loc.x;
    }

    public void setX(double d) {
        this.setPosition(d, this.loc.y);
    }

    public double getY() {
        return this.loc.y;
    }

    public void setY(double d) {
        this.setPosition(this.loc.x, d);
    }

    public void setPosition(double d, double d2) {
        this.loc.x = d >= 0.0 ? d : 0.0;
        this.loc.y = d2 >= 0.0 ? d2 : 0.0;
        this.centre.x = this.loc.x + this.getWidth() / 2.0;
        this.centre.y = this.loc.y + this.getHeight() / 2.0;
        this.pos.x = this.loc.x;
        this.pos.y = this.loc.y;
        this.mep.setPosition(this.loc.x, this.loc.y);
        this.model.newOuterBound(this.loc.x + this.getWidth(), this.loc.y + this.getHeight());
    }

    public abstract double getWidth();

    public void setWidth(double d) {
        this.loc.width = d;
    }

    public abstract double getHeight();

    public void setHeight(double d) {
        this.loc.height = d;
    }

    public IDElement getId() {
        return this.id;
    }

    public void setId(IDElement iDElement) {
        this.id = iDElement;
    }

    public void setMarked(boolean bl) {
        if (this.marked != bl) {
            this.marked = bl;
            if (this.marked) {
                this.model.addMarkedPanel(this.mep);
            } else {
                this.model.removeMarkedPanel(this.mep);
            }
            this.mep.repaint();
        }
    }

    public boolean isMarked() {
        return this.marked;
    }

    public boolean toggleMarked() {
        boolean bl = this.marked = !this.marked;
        if (this.marked) {
            this.model.addMarkedPanel(this.mep);
        } else {
            this.model.removeMarkedPanel(this.mep);
        }
        this.mep.repaint();
        return this.marked;
    }

    public abstract void removeUsers();

    public void removeMe() {
        this.setMarked(false);
        this.mep.removeMe();
        this.id.kill();
        this.arr.removeElement(this);
        this.removeUsers();
    }

    public void kill() {
        this.removeMe();
        this.model.getModelFolder().doValidation();
        this.model.getModelPanelInside().repaint();
    }

    public void setArray(IElementArray iElementArray) {
        this.arr = iElementArray;
    }

    public void setMouseOverColor(boolean bl) {
        this.mouseOver = bl;
        this.actual_Color = bl ? this.colorOver : this.colorNormal;
    }

    public void move(int n, int n2) {
        this.moveX += n;
        this.moveY += n2;
    }

    public void confirmMoving() {
        this.setPosition(this.loc.x + (double)this.moveX, this.loc.y + (double)this.moveY);
        this.resetMoving();
    }

    public void resetMoving() {
        this.moveX = 0;
        this.moveY = 0;
    }

    public void setExclusiveMarked() {
        this.model.removeMarks();
        this.setMarked(true);
    }

    public void setAdditionalMarked() {
        this.toggleMarked();
    }

    protected abstract ModelElementPanel constructSpecificPanel();

    public Model getModel() {
        return this.model;
    }

    public double getCentreX() {
        return this.centre.x;
    }

    public double getCentreY() {
        return this.centre.y;
    }

    public Point2D.Double getCentre() {
        return this.centre;
    }

    public abstract Point2D.Double getConnectionPoint2D(Point2D.Double var1);

    public void doValidation() {
        this.valid = true;
    }

    protected void drawInvalidSymbol(Graphics2D graphics2D, Point2D.Double double_) {
        this.invalidScheibe.x = double_.x - this.invalidScheibe.width / 2.0;
        this.invalidScheibe.y = double_.y - this.invalidScheibe.height / 2.0;
        graphics2D.setColor(this.invalidBackgroundColor);
        graphics2D.fill(this.invalidScheibe);
        graphics2D.setFont(this.invalidFont);
        graphics2D.setColor(this.invalidForegroundColor);
        graphics2D.drawString(this.invalidString, (float)(double_.x - (double)(graphics2D.getFontMetrics().stringWidth(this.invalidString) / 2)), (float)(double_.y + (double)(this.invalidFont.getSize2D() / 2.0f)));
    }

    public abstract void save(DataOutputStream var1) throws IOException;

    public abstract void load(DataInputStream var1) throws IOException;
}

