/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.table;

import java.text.DecimalFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class DoubleRenderer
extends DefaultTableCellRenderer {
    DecimalFormat formatter;
    DecimalFormat formatterSmall;
    int digitsAfterComma = 3;

    public DoubleRenderer() {
        this(new DecimalFormat("0.###E0"));
    }

    public DoubleRenderer(String string) {
        this(new DecimalFormat(string));
    }

    public DoubleRenderer(DecimalFormat decimalFormat) {
        this.formatter = decimalFormat;
        this.formatterSmall = new DecimalFormat("######.###");
        this.setHorizontalAlignment(4);
    }

    public void setValue(Object object) {
        double d = (Double)object;
        if (Math.abs(d) < 1000000.0 && Math.abs(d) >= 0.1 || d == 0.0) {
            this.setText(object == null ? "" : this.formatterSmall.format((Double)object));
        } else {
            this.setText(object == null ? "" : this.formatter.format((Double)object));
        }
    }

    public void setDigitsAfterComma(int n) {
        this.digitsAfterComma = n;
        StringBuffer stringBuffer = new StringBuffer("0");
        if (n >= 1) {
            stringBuffer.append(".");
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("#");
            ++n2;
        }
        stringBuffer.append("E0");
        this.formatter = new DecimalFormat(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer.append("#####0");
        if (n >= 1) {
            stringBuffer.append(".");
        }
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append("#");
            ++n3;
        }
        this.formatterSmall = new DecimalFormat(stringBuffer.toString());
    }

    public int getDigitsAfterComma() {
        return this.digitsAfterComma;
    }

    public String formatMe(double d) {
        if (Math.abs(d) < 1000000.0 && Math.abs(d) >= 0.1 || d == 0.0) {
            return this.formatterSmall.format(d);
        }
        return this.formatter.format(d);
    }
}

