/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.id;

import frei_benno.dynamic.model.ModelFolder;
import frei_benno.dynamic.model.id.IDElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class IDHandler {
    private static final int IDARR_INITIAL_SIZE = 10;
    private static final int IDARR_INCREMENT = 10;
    private ModelFolder modelFolder;
    private int newId = 0;
    private int idArr_size;
    private int idArr_pos;
    private IDElement[] idArr;
    private boolean loadingStatus = false;

    public IDHandler(ModelFolder modelFolder) {
        this.modelFolder = modelFolder;
        this.idArr_size = 10;
        this.idArr_pos = 0;
        this.idArr = new IDElement[this.idArr_size];
    }

    private void incrementArraySize() {
        this.idArr_size += 10;
        IDElement[] iDElementArray = new IDElement[this.idArr_size];
        System.arraycopy(this.idArr, 0, iDElementArray, 0, this.idArr_pos);
        this.idArr = iDElementArray;
    }

    public void setLoadingStatus(boolean bl) {
        this.loadingStatus = bl;
    }

    public boolean isLoading() {
        return this.loadingStatus;
    }

    private void addIDElement(IDElement iDElement) {
        if (this.idArr_pos >= this.idArr_size) {
            this.incrementArraySize();
        }
        this.idArr[this.idArr_pos++] = iDElement;
    }

    public void removeIDElement(IDElement iDElement) {
        int n = 0;
        while (n < this.idArr_pos && this.idArr[n] != iDElement) {
            ++n;
        }
        if (n < this.idArr_pos) {
            this.idArr[n] = this.idArr[--this.idArr_pos];
            this.idArr[this.idArr_pos] = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isNameAvailable(String var1_1) {
        var2_2 = 0;
        if (this.areAllCharactersAllowed(var1_1)) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            if (var1_1.equals(this.idArr[var2_2].getName())) {
                return false;
            }
            ++var2_2;
lbl7:
            // 2 sources

            ** while (var2_2 < this.idArr_pos)
        }
lbl8:
        // 1 sources

        return true;
    }

    private boolean areAllCharactersAllowed(String string) {
        boolean bl = true;
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (Character.isDigit(c)) {
            bl = false;
        }
        int n = 0;
        while (n < string.length() && bl) {
            c = string.charAt(n);
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '_') {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public synchronized IDElement createNewID(Object object) {
        return this.createNewID(null, object);
    }

    public synchronized IDElement createNewID(String string, Object object) {
        if (!this.loadingStatus) {
            if (string == null || string.length() == 0) {
                string = "ELE_" + this.newId;
            }
            while (!this.isNameAvailable(string)) {
                string = string + this.newId;
            }
            IDElement iDElement = new IDElement(this, this.newId++, string, object);
            this.addIDElement(iDElement);
            return iDElement;
        }
        return null;
    }

    public IDElement loadId(int n, Object object) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.idArr_pos && n2 < 0) {
            if (this.idArr[n3].getId() == n) {
                n2 = n3;
            }
            ++n3;
        }
        if (n2 >= 0) {
            this.idArr[n2].setOwner(object);
            return this.idArr[n2];
        }
        return null;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.idArr_pos);
        dataOutputStream.writeInt(this.newId);
        int n = 0;
        while (n < this.idArr_pos) {
            this.idArr[n].save(dataOutputStream);
            ++n;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.idArr_size = this.idArr_pos = dataInputStream.readInt();
        this.idArr = new IDElement[this.idArr_size];
        this.newId = dataInputStream.readInt();
        int n = 0;
        while (n < this.idArr_pos) {
            this.idArr[n] = new IDElement(this, 0, null, null);
            this.idArr[n].load(dataInputStream);
            ++n;
        }
    }

    public IDElement getIdElement(int n) {
        int n2 = 0;
        while (n2 < this.idArr_pos) {
            if (this.idArr[n2].getId() == n) {
                return this.idArr[n2];
            }
            ++n2;
        }
        return null;
    }
}

