/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.graphic;

import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.graphic.ValuesPanelEditor_this_componentAdapter;
import frei_benno.dynamic.model.graphic.ValuesPanelEditor_this_mouseMotionAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class ValuesPanelEditor
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    private int anzValues = 20;
    private double[][] values = new double[this.anzValues + 1][2];
    private int[] timesKo = new int[this.anzValues + 1];
    private int[] valuesKo = new int[this.anzValues + 1];
    private double minTime = 0.0;
    private double maxTime = 10.0;
    private double minValue = 0.0;
    private double maxValue = 10.0;
    private boolean setting = false;

    public ValuesPanelEditor() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getMinTime() {
        return this.minTime;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void newBoundsSet() {
        if (this.minTime != this.values[0][0] || this.maxTime != this.values[this.values.length - 1][0]) {
            int n = 0;
            while (n < this.values.length) {
                this.values[n][0] = this.minTime + (double)n * (this.maxTime - this.minTime) / (double)(this.values.length - 1);
                ++n;
            }
        }
        this.recalculateKo();
        this.repaint();
    }

    public void setMinTime(double d) {
        if (d < this.maxTime) {
            this.minTime = d;
            this.newBoundsSet();
        } else {
            Message.write("ERROR:\nMin Zeit muss kleiner sein als Max Zeit");
        }
    }

    public void setMaxTime(double d) {
        if (d > this.minTime) {
            this.maxTime = d;
            this.newBoundsSet();
        } else {
            Message.write("ERROR:\nMin Zeit muss kleiner sein als Max Zeit");
        }
    }

    public void setMinValue(double d) {
        if (d < this.maxValue) {
            this.minValue = d;
            this.newBoundsSet();
        } else {
            Message.write("ERROR:\nMin Wert muss kleiner sein als Max Wert");
        }
    }

    public void setMaxValue(double d) {
        if (d > this.minValue) {
            this.maxValue = d;
            this.newBoundsSet();
        } else {
            Message.write("ERROR:\nMin Wert muss kleiner sein als Max Wert");
        }
    }

    private Point findKo(double d, double d2) {
        Point point = new Point();
        point.x = (int)((double)this.getWidth() * (d - this.minTime) / (this.maxTime - this.minTime));
        point.y = this.getHeight() - 1 - (int)((double)this.getHeight() * (d2 - this.minValue) / (this.maxValue - this.minValue));
        return point;
    }

    private Point2D.Double findRealKo(int n, int n2) {
        Point2D.Double double_ = new Point2D.Double();
        double_.x = this.minTime + (this.maxTime - this.minTime) / (double)this.getWidth() * (double)n;
        double_.y = this.maxValue - (this.maxValue - this.minValue) / (double)this.getHeight() * (double)n2;
        return double_;
    }

    private void recalculateKo() {
        int n = 0;
        while (n < this.values.length) {
            Point point = this.findKo(this.values[n][0], this.values[n][1]);
            this.timesKo[n] = point.x;
            this.valuesKo[n] = point.y;
            ++n;
        }
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.gray);
        int n = 0;
        while (n < this.anzValues) {
            graphics.drawLine(n * this.getWidth() / this.anzValues, 0, n * this.getWidth() / this.anzValues, this.getHeight());
            graphics.drawLine(0, n * this.getHeight() / this.anzValues, this.getWidth(), n * this.getHeight() / this.anzValues);
            ++n;
        }
        graphics.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        if (!this.setting) {
            graphics.setColor(Color.red);
            int n2 = 0;
            while (n2 < this.anzValues) {
                graphics.drawLine(this.timesKo[n2], this.valuesKo[n2], this.timesKo[n2 + 1], this.valuesKo[n2 + 1]);
                ++n2;
            }
        }
    }

    void jbInit() throws Exception {
        this.addMouseMotionListener(new ValuesPanelEditor_this_mouseMotionAdapter(this));
        this.addComponentListener(new ValuesPanelEditor_this_componentAdapter(this));
        this.setLayout(this.borderLayout1);
        int n = 0;
        while (n < this.values.length) {
            this.values[n][0] = this.minTime + (double)n * (this.maxTime - this.minTime) / (double)this.anzValues;
            this.values[n][1] = this.minValue + (double)n * (this.maxValue - this.minValue) / (double)this.anzValues;
            Point point = this.findKo(this.values[n][0], this.values[n][1]);
            this.timesKo[n] = point.x;
            this.valuesKo[n] = point.y;
            ++n;
        }
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.recalculateKo();
    }

    private int getArrPos(int n) {
        return (int)(((double)n + (double)this.getWidth() / (double)(this.anzValues * 2)) / ((double)this.getWidth() / (double)this.anzValues));
    }

    void this_mouseDragged(MouseEvent mouseEvent) {
        int n = this.getArrPos(mouseEvent.getX());
        if (n >= 0 && n <= this.anzValues) {
            int n2;
            int n3 = mouseEvent.getX();
            if (n3 <= 0) {
                n3 = 1;
            }
            if (n3 >= this.getWidth()) {
                n3 = this.getWidth() - 1;
            }
            if ((n2 = mouseEvent.getY()) <= 0) {
                n2 = 1;
            }
            if (n2 >= this.getHeight()) {
                n2 = this.getHeight() - 1;
            }
            Point2D.Double double_ = this.findRealKo(n3, n2);
            this.values[n][1] = double_.y;
            Point point = this.findKo(this.values[n][0], this.values[n][1]);
            this.valuesKo[n] = point.y;
            this.repaint();
        }
    }

    public void setValues(double[][] dArray) {
        this.setting = true;
        this.values = dArray;
        this.minTime = dArray[0][0];
        this.maxTime = dArray[dArray.length - 1][0];
        this.minValue = dArray[0][1];
        this.maxValue = dArray[0][1];
        this.anzValues = dArray.length - 1;
        int n = 1;
        while (n < dArray.length) {
            if (this.minValue > dArray[n][1]) {
                this.minValue = dArray[n][1];
            }
            if (this.maxValue < dArray[n][1]) {
                this.maxValue = dArray[n][1];
            }
            ++n;
        }
        this.timesKo = new int[dArray.length];
        this.valuesKo = new int[dArray.length];
        this.recalculateKo();
        this.setting = false;
        this.repaint();
    }
}

