/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.graphic;

import frei_benno.dynamic.model.IDrawable;
import frei_benno.dynamic.model.IDrawable2D;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class Arrow
implements IDrawable,
IDrawable2D {
    public static final double ARROWHEADLENGTH = 6.0;
    public static final double ARROW_WINKEL_SPITZE = 0.5235987755982988;
    private Point2D.Double start = new Point2D.Double();
    private Point2D.Double ziel = new Point2D.Double();
    private boolean initialized = false;
    private Line2D.Double line1;
    private Line2D.Double line2;
    private Line2D.Double line3;
    private Point2D.Double ps1 = new Point2D.Double();
    private Point2D.Double ps2 = new Point2D.Double();

    public Arrow() {
        this.line1 = new Line2D.Double();
        this.line2 = new Line2D.Double();
        this.line3 = new Line2D.Double();
    }

    public void setCoordinates(Point2D.Double double_, Point2D.Double double_2) {
        this.initialized = true;
        if (double_.x == double_2.x && double_.y == double_2.y) {
            double_2.x += 1.0;
            double_2.y += 1.0;
        }
        this.start.x = double_.x;
        this.ziel.x = double_2.x;
        this.start.y = double_.y;
        this.ziel.y = double_2.y;
        double d = this.winkel();
        this.ps1.x = 6.0 * Math.cos(d - 0.5235987755982988) + double_2.x;
        this.ps1.y = 6.0 * Math.sin(d - 0.5235987755982988) + double_2.y;
        this.ps2.x = 6.0 * Math.cos(d + 0.5235987755982988) + double_2.x;
        this.ps2.y = 6.0 * Math.sin(d + 0.5235987755982988) + double_2.y;
        this.line1.setLine(double_, double_2);
        this.line2.setLine(double_2, this.ps1);
        this.line3.setLine(double_2, this.ps2);
    }

    private double winkel() {
        double d = 0.0;
        double d2 = this.start.x - this.ziel.x;
        double d3 = this.start.y - this.ziel.y;
        if (Math.abs(d2) > Math.abs(d3)) {
            d = Math.atan(d3 / d2);
            if (d2 < 0.0) {
                d += Math.PI;
            }
            if (d < 0.0) {
                d += Math.PI * 2;
            }
        } else {
            d = 1.5707963267948966 - Math.atan(d2 / d3);
            if (d3 < 0.0) {
                d += Math.PI;
            }
        }
        return d;
    }

    public void setStart(Point2D.Double double_) {
        this.setCoordinates(double_, this.ziel);
    }

    public void setZiel(Point2D.Double double_) {
        this.setCoordinates(this.start, double_);
    }

    public void move(double d, double d2) {
        this.ziel.x += d;
        this.ziel.y += d2;
        this.start.x += d;
        this.start.y += d2;
        this.ps1.x += d;
        this.ps1.y += d2;
        this.ps2.x += d;
        this.ps2.y += d2;
        this.line1.setLine(this.start, this.ziel);
        this.line2.setLine(this.ziel, this.ps1);
        this.line3.setLine(this.ziel, this.ps2);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        if (this.initialized) {
            graphics2D.draw(this.line1);
            graphics2D.draw(this.line2);
            graphics2D.draw(this.line3);
        }
    }
}

