/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.Graphic;
import frei_benno.dynamic.model.Line;
import frei_benno.dynamic.model.PhaseLine;
import frei_benno.dynamic.model.Simulation;
import frei_benno.dynamic.model.array.SimulationArray;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class LineArray {
    private Graphic graphic;
    private static final int INITIAL_SIZE = 5;
    private static final int INCREMENT = 5;
    private Line[] arr;
    private int arr_size;
    private int arr_pos;

    public LineArray(Graphic graphic) {
        this.graphic = graphic;
        this.arr_size = 5;
        this.arr_pos = 0;
        this.arr = new Line[this.arr_size];
    }

    public float drawLegende(Graphics2D graphics2D, float f, float f2, float f3) {
        float f4 = f3;
        int n = 0;
        while (n < this.arr_pos) {
            f4 = this.arr[n].drawLegende(graphics2D, f, f2, f4);
            f4 += 10.0f;
            ++n;
        }
        graphics2D.setColor(Color.black);
        Rectangle2D.Float float_ = new Rectangle2D.Float(f - 8.0f, f3 - 8.0f, f2 + 16.0f, (f4 -= 10.0f) - f3 + 16.0f);
        graphics2D.draw(float_);
        return f4;
    }

    public SimulationArray getAllSimulations() {
        SimulationArray simulationArray = new SimulationArray(null);
        int n = 0;
        while (n < this.arr_pos) {
            Simulation simulation = (Simulation)this.arr[n].getSimulationId().getOwner();
            if (!simulationArray.isInside(simulation)) {
                simulationArray.addElement(simulation);
            }
            ++n;
        }
        return simulationArray;
    }

    public boolean isElementThere(IDElement iDElement) {
        boolean bl = false;
        int n = 0;
        while (n < this.arr_pos && !bl) {
            if (this.arr[n].getElementId() == iDElement) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        Line[] lineArray = new Line[this.arr_size];
        System.arraycopy(this.arr, 0, lineArray, 0, this.arr_pos);
        this.arr = lineArray;
    }

    public void addElement(Line line) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        this.arr[this.arr_pos++] = line;
    }

    public int length() {
        return this.arr_pos;
    }

    public Line getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public void removeElement(Line line) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != line) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_pos = this.arr_size = dataInputStream.readInt();
        this.arr = new Line[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            int n2 = dataInputStream.readInt();
            this.arr[n] = n2 == 0 ? new PhaseLine(this.graphic, null, null, null, null) : new Line(this.graphic, null, null);
            this.arr[n].load(dataInputStream);
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            if (this.arr[n] instanceof PhaseLine) {
                dataOutputStream.writeInt(0);
            } else {
                dataOutputStream.writeInt(1);
            }
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent, AffineTransform affineTransform) {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].draw2D(graphics2D, jComponent, affineTransform);
            ++n;
        }
    }

    public Rectangle2D.Double getRectVal() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.arr_pos == 0) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 300.0;
            double d4 = 200.0;
        } else {
            double d = this.arr[0].getMinTime();
            double d5 = this.arr[0].getMaxTime();
            double d6 = this.arr[0].getMinVal();
            double d7 = this.arr[0].getMaxVal();
            int n = 1;
            while (n < this.arr_pos) {
                if (this.arr[n].getMinTime() < d) {
                    d = this.arr[n].getMinTime();
                }
                if (this.arr[n].getMaxTime() > d5) {
                    d5 = this.arr[n].getMaxTime();
                }
                if (this.arr[n].getMinVal() < d6) {
                    d6 = this.arr[n].getMinVal();
                }
                if (this.arr[n].getMaxVal() > d7) {
                    d7 = this.arr[n].getMaxVal();
                }
                ++n;
            }
            double_.x = d;
            double_.width = d5 - d;
            double_.y = d6;
            double_.height = d7 - d6;
        }
        return double_;
    }

    public void reload() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].reloadData();
            ++n;
        }
    }

    public boolean isSimElementThere(IDElement iDElement, IDElement iDElement2) {
        boolean bl = false;
        int n = 0;
        while (n < this.arr_pos && !bl) {
            if (!(this.arr[n] instanceof PhaseLine) && this.arr[n].getSimulationId() == iDElement && this.arr[n].getElementId() == iDElement2) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean isSimElementThere(IDElement iDElement, IDElement iDElement2, IDElement iDElement3, IDElement iDElement4) {
        boolean bl = false;
        int n = 0;
        while (n < this.arr_pos && !bl) {
            PhaseLine phaseLine;
            if (this.arr[n] instanceof PhaseLine && (phaseLine = (PhaseLine)this.arr[n]).getSimulationId() == iDElement && phaseLine.getElementId() == iDElement2 && phaseLine.getSimulationIdY() == iDElement3 && phaseLine.getElementIdY() == iDElement4) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void recalculateShape(AffineTransform affineTransform) {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].recalculateShape(affineTransform);
            ++n;
        }
    }

    public Line[] getAll() {
        Line[] lineArray = new Line[this.arr_pos];
        int n = 0;
        while (n < this.arr_pos) {
            lineArray[n] = this.arr[n];
            ++n;
        }
        return lineArray;
    }
}

