/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.EState;
import frei_benno.dynamic.model.IDrawable;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.array.IElementArray;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EStateArray
implements IElementArray,
IDrawable,
IDrawable2D {
    private static final int INITIAL_SIZE = 10;
    private static final int INCREMENT = 5;
    private Model model;
    private EState[] arr;
    private int arr_size;
    private int arr_pos;

    public EStateArray(Model model) {
        this.model = model;
        this.arr_size = 10;
        this.arr_pos = 0;
        this.arr = new EState[this.arr_size];
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        EState[] eStateArray = new EState[this.arr_size];
        System.arraycopy(this.arr, 0, eStateArray, 0, this.arr_pos);
        this.arr = eStateArray;
    }

    public void addElement(EState eState) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        eState.setArray(this);
        this.arr[this.arr_pos++] = eState;
    }

    public int getIndexOf(IDElement iDElement) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.arr_pos && n == -1) {
            if (this.arr[n2].getId() == iDElement) {
                n = 0;
            }
            ++n2;
        }
        return n;
    }

    public EState getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public int length() {
        return this.arr_pos;
    }

    public void removeElement(EState eState) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != eState) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void removeElement(Object object) {
        this.removeElement((EState)object);
    }

    public EState createNewState() {
        EState eState = new EState(this.model);
        this.addElement(eState);
        return eState;
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].draw2D(graphics2D, jComponent);
            ++n;
        }
    }

    public void removeMarks() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].setMarked(false);
            ++n;
        }
    }

    public void doValidation() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].doValidation();
            ++n;
        }
    }

    public EState[] getAll() {
        EState[] eStateArray = new EState[this.arr_pos];
        System.arraycopy(this.arr, 0, eStateArray, 0, this.arr_pos);
        return eStateArray;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_size = this.arr_pos = dataInputStream.readInt();
        this.arr = new EState[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = new EState(this.model);
            this.arr[n].load(dataInputStream);
            this.arr[n].setArray(this);
            ++n;
        }
    }

    public boolean isValid() {
        boolean bl = true;
        int n = 0;
        while (n < this.arr_pos && bl) {
            bl &= this.arr[n].isValid();
            ++n;
        }
        return bl;
    }

    public void approveFlows() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].approveFlows();
            ++n;
        }
    }

    public void resetFlows() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].resetFlows();
            ++n;
        }
    }

    public void setAllToStartValue() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].setValue(this.arr[n].getStartValue());
            ++n;
        }
    }

    public void resetGradient() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].resetGradient();
            ++n;
        }
    }
}

