/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.EFlow;
import frei_benno.dynamic.model.IDrawable;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.array.IElementArray;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EFlowArray
implements IElementArray,
IDrawable,
IDrawable2D {
    private static final int INITIAL_SIZE = 10;
    private static final int INCREMENT = 5;
    private Model model;
    private EFlow[] arr;
    private int arr_size;
    private int arr_pos;

    public EFlowArray(Model model) {
        this.model = model;
        this.arr_size = 10;
        this.arr_pos = 0;
        this.arr = new EFlow[this.arr_size];
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        EFlow[] eFlowArray = new EFlow[this.arr_size];
        System.arraycopy(this.arr, 0, eFlowArray, 0, this.arr_pos);
        this.arr = eFlowArray;
    }

    public void addElement(EFlow eFlow) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        eFlow.setArray(this);
        this.arr[this.arr_pos++] = eFlow;
    }

    public EFlow getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public int length() {
        return this.arr_pos;
    }

    public void removeElement(EFlow eFlow) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != eFlow) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void removeElement(Object object) {
        this.removeElement((EFlow)object);
    }

    public EFlow createNewFlow() {
        EFlow eFlow = new EFlow(this.model);
        this.addElement(eFlow);
        return eFlow;
    }

    public void removeMarks() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].setMarked(false);
            ++n;
        }
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].draw2D(graphics2D, jComponent);
            ++n;
        }
    }

    public void markAsMoving(IDElement iDElement) {
        int n = 0;
        while (n < this.arr_pos) {
            if (this.arr[n].getFrom() == iDElement || this.arr[n].getTo() == iDElement) {
                this.arr[n].markAsMoving();
            }
            ++n;
        }
    }

    public void confirmFlowMovings() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].confirmFlowMoving();
            ++n;
        }
    }

    public void checkForRemoving(IDElement iDElement) {
        boolean bl = false;
        int n = 0;
        while (n < this.arr_pos) {
            bl = false;
            if (this.arr[n].getFrom() == iDElement) {
                this.arr[n].setFrom(null);
                bl = true;
            }
            if (this.arr[n].getTo() == iDElement) {
                this.arr[n].setTo(null);
                bl = true;
            }
            if (this.arr[n].getFrom() == null && this.arr[n].getTo() == null) {
                this.arr[n].removeMe();
                --n;
            } else if (bl) {
                this.arr[n].recalculateCoordinates();
            }
            ++n;
        }
    }

    public void doValidation() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].doValidation();
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_size = this.arr_pos = dataInputStream.readInt();
        this.arr = new EFlow[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = new EFlow(this.model);
            this.arr[n].load(dataInputStream);
            this.arr[n].setArray(this);
            ++n;
        }
    }

    public IDElement[] getFrom(IDElement iDElement) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.arr_pos) {
            if (this.arr[n2].getFrom() == iDElement) {
                ++n;
            }
            ++n2;
        }
        IDElement[] iDElementArray = new IDElement[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.arr_pos) {
            if (this.arr[n3].getFrom() == iDElement) {
                iDElementArray[n++] = this.arr[n3].getId();
            }
            ++n3;
        }
        return iDElementArray;
    }

    public IDElement[] getTo(IDElement iDElement) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.arr_pos) {
            if (this.arr[n2].getTo() == iDElement) {
                ++n;
            }
            ++n2;
        }
        IDElement[] iDElementArray = new IDElement[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.arr_pos) {
            if (this.arr[n3].getTo() == iDElement) {
                iDElementArray[n++] = this.arr[n3].getId();
            }
            ++n3;
        }
        return iDElementArray;
    }

    public EFlow[] getAll() {
        EFlow[] eFlowArray = new EFlow[this.arr_pos];
        System.arraycopy(this.arr, 0, eFlowArray, 0, this.arr_pos);
        return eFlowArray;
    }

    public boolean isValid() {
        boolean bl = true;
        int n = 0;
        while (n < this.arr_pos && bl) {
            bl &= this.arr[n].isValid();
            ++n;
        }
        return bl;
    }

    public void letItFlow(double d) {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].letItFlow(d);
            ++n;
        }
    }

    public void setGradient() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].setGradient();
            ++n;
        }
    }

    public void activateSimulation() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].activateSimulation();
            ++n;
        }
    }

    public void deactivateSimulation() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].deactivateSimulation();
            ++n;
        }
    }
}

