/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.EConnection;
import frei_benno.dynamic.model.IDrawable;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.array.IElementArray;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EConnectionArray
implements IElementArray,
IDrawable,
IDrawable2D {
    private static final int INITIAL_SIZE = 10;
    private static final int INCREMENT = 5;
    private Model model;
    private EConnection[] arr;
    private int arr_size;
    private int arr_pos;

    public EConnectionArray(Model model) {
        this.model = model;
        this.arr_size = 10;
        this.arr_pos = 0;
        this.arr = new EConnection[this.arr_size];
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        EConnection[] eConnectionArray = new EConnection[this.arr_size];
        System.arraycopy(this.arr, 0, eConnectionArray, 0, this.arr_pos);
        this.arr = eConnectionArray;
    }

    public void addElement(EConnection eConnection) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        eConnection.setArray(this);
        this.arr[this.arr_pos++] = eConnection;
    }

    public EConnection getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public int length() {
        return this.arr_pos;
    }

    public void removeElement(EConnection eConnection) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != eConnection) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void removeElement(Object object) {
        this.removeElement((EConnection)object);
    }

    public EConnection createNewConnection(IDElement iDElement, IDElement iDElement2) {
        EConnection eConnection = null;
        if (this.checkIfConnectionAllowed(iDElement, iDElement2)) {
            eConnection = new EConnection(this.model);
            this.addElement(eConnection);
            eConnection.setFrom(iDElement);
            eConnection.setTo(iDElement2);
        }
        return eConnection;
    }

    public EConnection[] getAllFrom(IDElement iDElement) {
        EConnection[] eConnectionArray = new EConnection[this.arr_pos];
        int n = 0;
        int n2 = 0;
        while (n2 < this.arr_pos) {
            if (this.arr[n2].getFrom() == iDElement) {
                eConnectionArray[n++] = this.arr[n2];
            }
            ++n2;
        }
        EConnection[] eConnectionArray2 = new EConnection[n];
        System.arraycopy(eConnectionArray, 0, eConnectionArray2, 0, n);
        return eConnectionArray2;
    }

    private boolean checkIfConnectionAllowed(IDElement iDElement, IDElement iDElement2) {
        boolean bl = true;
        int n = 0;
        while (n < this.arr_pos && bl) {
            if (this.arr[n].getFrom() == iDElement && this.arr[n].getTo() == iDElement2) {
                bl = false;
                Message.write("Die Verbindung besteht bereits");
            }
            ++n;
        }
        if (bl) {
            boolean bl2 = bl = !this.wayFromAToB(iDElement2, iDElement);
            if (!bl) {
                Message.write("Zirkelschluss!!!");
            }
        }
        return bl;
    }

    public boolean wayFromAToB(IDElement iDElement, IDElement iDElement2) {
        boolean bl = false;
        EConnection[] eConnectionArray = this.getAllFrom(iDElement);
        int n = 0;
        while (n < eConnectionArray.length && !bl) {
            bl = eConnectionArray[n].getTo() == iDElement2 ? true : bl || this.wayFromAToB(eConnectionArray[n].getTo(), iDElement2);
            ++n;
        }
        return bl;
    }

    public EConnection[] getAllTo(IDElement iDElement) {
        EConnection[] eConnectionArray = new EConnection[this.arr_pos];
        int n = 0;
        int n2 = 0;
        while (n2 < this.arr_pos) {
            if (this.arr[n2].getTo() == iDElement) {
                eConnectionArray[n++] = this.arr[n2];
            }
            ++n2;
        }
        EConnection[] eConnectionArray2 = new EConnection[n];
        System.arraycopy(eConnectionArray, 0, eConnectionArray2, 0, n);
        return eConnectionArray2;
    }

    public EConnection[] getAllConnectedWith(IDElement iDElement) {
        EConnection[] eConnectionArray = new EConnection[this.arr_pos];
        int n = 0;
        int n2 = 0;
        while (n2 < this.arr_pos) {
            if (this.arr[n2].getFrom() == iDElement || this.arr[n2].getTo() == iDElement) {
                eConnectionArray[n++] = this.arr[n2];
            }
            ++n2;
        }
        EConnection[] eConnectionArray2 = new EConnection[n];
        System.arraycopy(eConnectionArray, 0, eConnectionArray2, 0, n);
        return eConnectionArray2;
    }

    public void removeMarks() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].setMarked(false);
            ++n;
        }
    }

    public void markAsMoving(IDElement iDElement) {
        int n = 0;
        while (n < this.arr_pos) {
            if (this.arr[n].getFrom() == iDElement || this.arr[n].getTo() == iDElement) {
                this.arr[n].markAsMoving();
            }
            ++n;
        }
    }

    public void confirmConnectionMovings() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].confirmConnectionMoving();
            ++n;
        }
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].draw2D(graphics2D, jComponent);
            ++n;
        }
    }

    public void doValidation() {
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_size = this.arr_pos = dataInputStream.readInt();
        this.arr = new EConnection[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = new EConnection(this.model);
            this.arr[n].load(dataInputStream);
            this.arr[n].setArray(this);
            ++n;
        }
    }

    public boolean isValid() {
        return true;
    }
}

