/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.numeric;

import frei_benno.dynamic.formula.numeric.SimValueSaver;
import frei_benno.dynamic.formula.numeric.Simulator;
import frei_benno.dynamic.model.EState;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelElementFunction;
import frei_benno.dynamic.model.Simulation;
import frei_benno.dynamic.model.array.EFlowArray;
import frei_benno.dynamic.model.array.EStateArray;
import frei_benno.dynamic.model.id.IDElement;

public class SimulatorRunge
extends Simulator {
    public static final String[] neededValues = new String[]{"Startzeit", "Stopzeit", "Speicherintervall", "Schrittweite"};
    public static final double[] neededValuesStandard = new double[]{0.0, 10.0, 0.1, 0.1};
    private double actualtime;
    private ModelElementFunction[] funArr;
    private EStateArray stateArr;

    public double getOldValue(IDElement iDElement, double d, double d2) {
        if (iDElement.getOwner() instanceof EState) {
            int n = this.stateArr.getIndexOf(iDElement);
            return this.simValueSaver.oldValue(0, n, this.actualtime - d, d2);
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.funArr.length && n == -1) {
            if (this.funArr[n2].getId() == iDElement) {
                n = n2;
            }
            ++n2;
        }
        return this.simValueSaver.oldValue(1, n, this.actualtime - d, d2);
    }

    public boolean isValid() {
        return true;
    }

    public void simulate(Model model, Simulation simulation) {
        int n;
        int n2;
        model.setSimulator(this);
        double d = this.simProperties.getValue("Startzeit");
        double d2 = this.simProperties.getValue("Stopzeit");
        this.actualtime = d;
        double d3 = this.simProperties.getValue("Schrittweite");
        double d4 = this.simProperties.getValue("Speicherintervall");
        int n3 = Math.round((float)d4 / (float)d3);
        if (n3 <= 0) {
            n3 = 1;
        }
        this.stateArr = model.getStateArray();
        this.stateArr.resetFlows();
        EFlowArray eFlowArray = model.getFlowArray();
        eFlowArray.activateSimulation();
        this.funArr = model.getSortetInterFlowElements();
        this.simValueSaver = new SimValueSaver(this, 1, this.stateArr.length(), this.funArr.length);
        model.setTime(this.actualtime);
        this.stateArr.setAllToStartValue();
        int n4 = 0;
        while (n4 < this.funArr.length) {
            this.funArr[n4].reeval();
            ++n4;
        }
        this.simValueSaver.addTimeValue(0, this.actualtime);
        int n5 = 0;
        while (n5 < this.stateArr.length()) {
            this.simValueSaver.addStateValue(n5, this.stateArr.getElement(n5).getValue());
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.funArr.length) {
            this.simValueSaver.addInterFlowValue(n6, this.funArr[n6].getValue());
            ++n6;
        }
        this.simValueSaver.finishStep();
        EState[] eStateArray = this.stateArr.getAll();
        double[][] dArray = new double[eStateArray.length][5];
        int n7 = 0;
        while (this.actualtime < d2) {
            ++n7;
            int n8 = 0;
            while (n8 < eStateArray.length) {
                dArray[n8][0] = eStateArray[n8].getValue();
                ++n8;
            }
            this.stateArr.resetGradient();
            eFlowArray.setGradient();
            n2 = 0;
            while (n2 < eStateArray.length) {
                dArray[n2][1] = eStateArray[n2].getGradient();
                eStateArray[n2].setValue(dArray[n2][0] + d3 / 2.0 * dArray[n2][1]);
                ++n2;
            }
            model.setTime(this.actualtime + d3 / 2.0);
            n = 0;
            while (n < this.funArr.length) {
                this.funArr[n].reeval();
                ++n;
            }
            this.stateArr.resetGradient();
            eFlowArray.setGradient();
            int n9 = 0;
            while (n9 < eStateArray.length) {
                dArray[n9][2] = eStateArray[n9].getGradient();
                eStateArray[n9].setValue(dArray[n9][0] + d3 / 2.0 * dArray[n9][2]);
                ++n9;
            }
            int n10 = 0;
            while (n10 < this.funArr.length) {
                this.funArr[n10].reeval();
                ++n10;
            }
            this.stateArr.resetGradient();
            eFlowArray.setGradient();
            int n11 = 0;
            while (n11 < eStateArray.length) {
                dArray[n11][3] = eStateArray[n11].getGradient();
                eStateArray[n11].setValue(dArray[n11][0] + d3 * dArray[n11][3]);
                ++n11;
            }
            model.setTime(this.actualtime + d3);
            int n12 = 0;
            while (n12 < this.funArr.length) {
                this.funArr[n12].reeval();
                ++n12;
            }
            this.stateArr.resetGradient();
            eFlowArray.setGradient();
            int n13 = 0;
            while (n13 < eStateArray.length) {
                dArray[n13][4] = eStateArray[n13].getGradient();
                eStateArray[n13].setValue(dArray[n13][0] + d3 / 6.0 * (dArray[n13][1] + 2.0 * dArray[n13][2] + 2.0 * dArray[n13][3] + dArray[n13][4]));
                ++n13;
            }
            this.actualtime = d + (double)n7 * d3;
            model.setTime(this.actualtime);
            int n14 = 0;
            while (n14 < this.funArr.length) {
                this.funArr[n14].reeval();
                ++n14;
            }
            if (n7 % n3 != 0 && !(this.actualtime >= d2)) continue;
            this.simValueSaver.addTimeValue(0, this.actualtime);
            int n15 = 0;
            while (n15 < this.stateArr.length()) {
                this.simValueSaver.addStateValue(n15, this.stateArr.getElement(n15).getValue());
                ++n15;
            }
            int n16 = 0;
            while (n16 < this.funArr.length) {
                this.simValueSaver.addInterFlowValue(n16, this.funArr[n16].getValue());
                ++n16;
            }
            this.simValueSaver.finishStep();
        }
        eFlowArray.deactivateSimulation();
        IDElement[] iDElementArray = new IDElement[1 + this.stateArr.length() + this.funArr.length];
        iDElementArray[0] = null;
        n2 = 0;
        while (n2 < this.stateArr.length()) {
            iDElementArray[1 + n2] = this.stateArr.getElement(n2).getId();
            ++n2;
        }
        n = 0;
        while (n < this.funArr.length) {
            iDElementArray[1 + this.stateArr.length() + n] = this.funArr[n].getId();
            ++n;
        }
        simulation.setIDList(iDElementArray);
        simulation.setValuesList(this.simValueSaver.getValArray());
        this.simValueSaver = null;
    }
}

