/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.numeric;

import frei_benno.dynamic.formula.numeric.SimProperties;
import frei_benno.dynamic.formula.numeric.Simulator;
import frei_benno.dynamic.formula.numeric.SimulatorEuler;
import frei_benno.dynamic.formula.numeric.SimulatorRunge;
import frei_benno.dynamic.formula.numeric.SimulatorRungeAuto;

public class SimulatorFactory {
    private static final int ALGO_EULER = 0;
    private static final int ALGO_RUNGEKUTTA = 1;
    private static final int ALGO_RUNGEKUTTA_AUTOMATISCH = 2;
    private static final String[] SIM_LISTE = new String[]{"Euler-Cauchy", "Runge-Kutta", "Runge-Kutta mit Schrittweitensteuerung"};

    public static String[] getSimulatorListe() {
        return SIM_LISTE;
    }

    public static Simulator getSimulatorInstance(SimProperties simProperties) {
        Simulator simulator = null;
        if (simProperties.getSimulator() == 0) {
            simulator = new SimulatorEuler();
            simulator.setSimProperties(simProperties);
        }
        if (simProperties.getSimulator() == 1) {
            simulator = new SimulatorRunge();
            simulator.setSimProperties(simProperties);
        }
        if (simProperties.getSimulator() == 2) {
            simulator = new SimulatorRungeAuto();
            simulator.setSimProperties(simProperties);
        }
        return simulator;
    }

    public static void getPropertiesFor(String string, SimProperties simProperties) {
        if (string.equals(SIM_LISTE[0])) {
            simProperties.setActualNeededValues(SimulatorEuler.neededValues, SimulatorEuler.neededValuesStandard);
            simProperties.setSimulator(0);
        }
        if (string.equals(SIM_LISTE[1])) {
            simProperties.setActualNeededValues(SimulatorRunge.neededValues, SimulatorRunge.neededValuesStandard);
            simProperties.setSimulator(1);
        }
        if (string.equals(SIM_LISTE[2])) {
            simProperties.setActualNeededValues(SimulatorRungeAuto.neededValues, SimulatorRungeAuto.neededValuesStandard);
            simProperties.setSimulator(2);
        }
    }
}

