/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.numeric;

import frei_benno.dynamic.formula.numeric.Simulator;
import frei_benno.dynamic.formula.numeric.SimulatorFactory;
import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.Simulation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.table.AbstractTableModel;

public class SimProperties
extends AbstractTableModel {
    private static final Class cld = new Double(0.0).getClass();
    private static final Class cl = new String("").getClass();
    private static final int INITIAL = 5;
    private static final int INCREMENT = 5;
    private String[] names = new String[this.names_len];
    private int[] neededValuesIndex;
    private int names_pos = 0;
    private int names_len = 5;
    private double[] values = new double[this.names_len];
    private int simulator = 0;

    private void incrementArraySize() {
        if (this.names_pos >= this.names_len) {
            this.names_len += 5;
            String[] stringArray = new String[this.names_len];
            double[] dArray = new double[this.names_len];
            System.arraycopy(this.names, 0, stringArray, 0, this.names_pos);
            System.arraycopy(this.values, 0, dArray, 0, this.names_pos);
            this.names = stringArray;
            this.values = dArray;
        }
    }

    public double getValue(String string) {
        int n = 0;
        while (n < this.names_pos) {
            if (this.names[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return Double.NaN;
    }

    public int getValuePos(String string) {
        int n = 0;
        while (n < this.names_pos) {
            if (this.names[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setValue(String string, double d) {
        int n = 0;
        while (n < this.names_pos++) {
            if (this.names[n].equals(string)) {
                this.values[n] = d;
            }
            ++n;
        }
    }

    public void addValue(String string, double d) {
        boolean bl = false;
        int n = 0;
        while (n < this.names_pos && !bl) {
            if (this.names[n].equals(string)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            this.incrementArraySize();
            this.names[this.names_pos] = string;
            this.values[this.names_pos++] = d;
        }
    }

    public Object[][] getAll() {
        Object[][] objectArray = new Object[this.names_pos][2];
        int n = 0;
        while (n < this.names_pos) {
            objectArray[n][0] = this.names[n];
            objectArray[n][1] = new Double(this.values[n]);
            ++n;
        }
        return objectArray;
    }

    public void removeAll() {
        this.names_pos = 0;
        this.names_len = 5;
        this.names = new String[this.names_len];
        this.values = new double[this.names_len];
    }

    public void setActualNeededValues(String[] stringArray, double[] dArray) {
        this.neededValuesIndex = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (this.getValuePos(stringArray[n]) == -1) {
                this.addValue(stringArray[n], dArray[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.neededValuesIndex[n2] = this.getValuePos(stringArray[n2]);
            ++n2;
        }
    }

    public int getRowCount() {
        return this.neededValuesIndex.length;
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.names[this.neededValuesIndex[n]];
        }
        return new Double(this.values[this.neededValuesIndex[n]]);
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Eigenschaft";
        }
        return "Wert";
    }

    public Class getColumnClass(int n) {
        if (n == 1) {
            return cld;
        }
        return cl;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            this.values[this.neededValuesIndex[n]] = (Double)object;
        }
        catch (Exception exception) {}
    }

    public void setSimulator(int n) {
        this.simulator = n;
    }

    public int getSimulator() {
        return this.simulator;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.names_len = dataInputStream.readInt();
        this.simulator = dataInputStream.readInt();
        this.names_pos = this.names_len;
        this.names = new String[this.names_len];
        this.values = new double[this.names_len];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.names_pos) {
            char c = dataInputStream.readChar();
            stringBuffer.setLength(0);
            while ((c = dataInputStream.readChar()) != '\"') {
                stringBuffer.append(c);
            }
            this.names[n] = stringBuffer.toString();
            this.values[n] = dataInputStream.readDouble();
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.names_pos);
        dataOutputStream.writeInt(this.simulator);
        int n = 0;
        while (n < this.names_pos) {
            dataOutputStream.writeChars("\"");
            dataOutputStream.writeChars(this.names[n]);
            dataOutputStream.writeChars("\"");
            dataOutputStream.writeDouble(this.values[n]);
            ++n;
        }
    }

    public void simulate(Model model, Simulation simulation) {
        if (model.isValid() && !model.isEmpty()) {
            Simulator simulator = SimulatorFactory.getSimulatorInstance(this);
            simulator.simulate(model, simulation);
        } else {
            if (!model.isValid()) {
                Message.write("ERROR: Es kann nicht simuliert werden. Das Modell ist ung\u00fcltig");
            }
            if (model.isEmpty()) {
                Message.write("ERROR: Es kann nicht simuliert werden. Es wurde noch kein Modell erstellt");
            }
        }
    }

    public void takeThis(SimProperties simProperties) {
        Object[][] objectArray = simProperties.getAll();
        this.removeAll();
        int n = 0;
        while (n < objectArray.length) {
            this.addValue((String)objectArray[n][0], (Double)objectArray[n][1]);
            ++n;
        }
        this.simulator = simProperties.getSimulator();
    }
}

