/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.table;

import frei_benno.dynamic.table.LineDash;
import frei_benno.dynamic.table.LineThickness;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class LineRenderer
extends JPanel
implements TableCellRenderer,
ListCellRenderer {
    BorderLayout borderLayout1 = new BorderLayout();
    private float[] dash = null;
    private float thick = 1.0f;
    private Color bckColor = Color.white;

    public LineRenderer() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.bckColor);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(this.thick, 0, 2, 1.0f, this.dash, 0.0f));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(5.0f, (float)this.getHeight() / 2.0f);
        generalPath.lineTo((float)this.getWidth() - 5.0f, (float)this.getHeight() / 2.0f);
        graphics2D.draw(generalPath);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof LineDash) {
            this.dash = ((LineDash)object).getDash();
            this.thick = 1.0f;
        } else {
            this.dash = null;
            this.thick = ((LineThickness)object).getThickness();
        }
        return this;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof LineDash) {
            this.dash = ((LineDash)object).getDash();
            this.thick = 1.0f;
        } else {
            this.dash = null;
            this.thick = ((LineThickness)object).getThickness();
        }
        this.setPreferredSize(new Dimension(jList.getWidth(), 15));
        return this;
    }
}

