/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.model.Bericht;
import frei_benno.dynamic.model.ModelFile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class BerichtArray {
    private ModelFile modelFile;
    private static final int INITIAL_SIZE = 5;
    private static final int INCREMENT = 5;
    private Bericht[] arr;
    private int arr_size;
    private int arr_pos;

    public BerichtArray(ModelFile modelFile) {
        this.modelFile = modelFile;
        this.arr_size = 5;
        this.arr_pos = 0;
        this.arr = new Bericht[this.arr_size];
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        Bericht[] berichtArray = new Bericht[this.arr_size];
        System.arraycopy(this.arr, 0, berichtArray, 0, this.arr_pos);
        this.arr = berichtArray;
    }

    public void addElement(Bericht bericht) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        this.arr[this.arr_pos++] = bericht;
    }

    public int length() {
        return this.arr_pos;
    }

    public Bericht getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public void removeElement(Bericht bericht) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != bericht) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_pos = this.arr_size = dataInputStream.readInt();
        this.arr = new Bericht[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = this.modelFile != null ? new Bericht(this.modelFile) : new Bericht(this.modelFile);
            this.arr[n].load(dataInputStream);
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }
}

