/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.formula.math.FConstant;
import frei_benno.dynamic.formula.math.FOwnTable;
import frei_benno.dynamic.formula.math.FUnparsable;
import frei_benno.dynamic.formula.math.IFunction;
import frei_benno.dynamic.formula.parser.Parser;
import frei_benno.dynamic.message.MessageDialog;
import frei_benno.dynamic.model.EConnection;
import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.ModelElementFunction;
import frei_benno.dynamic.model.id.IDElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FunctionString {
    private static final int INITIAL_SIZE = 3;
    private static final int INCREMENT = 3;
    private ModelElementFunction mef;
    private String[] stringteile;
    private IDElement[] ids;
    private int stringteile_len;
    private int stringteile_pos;
    private int ids_len;
    private int ids_pos;
    private boolean ownValues = false;
    private IFunction function;
    public double[][] vals;
    public double zeroVal;

    public FunctionString(ModelElementFunction modelElementFunction) {
        this.mef = modelElementFunction;
        this.stringteile_len = 3;
        this.stringteile_pos = 0;
        this.stringteile = new String[this.stringteile_len];
        this.stringteile[this.stringteile_pos++] = "";
        this.ids_len = 3;
        this.ids_pos = 0;
        this.ids = new IDElement[this.ids_len];
    }

    public void setFunction(IFunction iFunction) {
        this.function = iFunction;
    }

    public IFunction getFunction() {
        return this.function;
    }

    public IDElement[] getIds() {
        IDElement[] iDElementArray = new IDElement[this.ids_pos];
        System.arraycopy(this.ids, 0, iDElementArray, 0, this.ids_pos);
        return iDElementArray;
    }

    public ModelElement getModelElement() {
        return this.mef;
    }

    private void resetArrays() {
        this.stringteile_len = 3;
        this.stringteile_pos = 0;
        this.stringteile = new String[this.stringteile_len];
        this.ids_len = 3;
        this.ids_pos = 0;
        this.ids = new IDElement[this.ids_len];
    }

    private void incrementArraySize() {
        this.stringteile_len += 3;
        this.ids_len += 3;
        String[] stringArray = new String[this.stringteile_len];
        IDElement[] iDElementArray = new IDElement[this.ids_len];
        System.arraycopy(this.stringteile, 0, stringArray, 0, this.stringteile_pos);
        System.arraycopy(this.ids, 0, iDElementArray, 0, this.ids_pos);
        this.stringteile = stringArray;
        this.ids = iDElementArray;
    }

    private void addStringTeil(String string) {
        if (this.stringteile_pos >= this.stringteile_len) {
            this.incrementArraySize();
        }
        this.stringteile[this.stringteile_pos++] = string;
    }

    private void addIDTeil(IDElement iDElement) {
        if (this.ids_pos >= this.ids_len) {
            this.incrementArraySize();
        }
        this.ids[this.ids_pos++] = iDElement;
    }

    public boolean getOwnValues() {
        return this.ownValues;
    }

    public void setOwnValues(boolean bl) {
        this.ownValues = bl;
    }

    public void setOwnValues(double[][] dArray, double d) {
        this.ownValues = true;
        this.vals = dArray;
        this.zeroVal = d;
        FOwnTable fOwnTable = new FOwnTable();
        FConstant fConstant = new FConstant();
        fConstant.setValue(d);
        fOwnTable.setModel(this.mef.getModel());
        fOwnTable.setOutValue(fConstant);
        fOwnTable.setValues(dArray);
        this.function = fOwnTable;
    }

    public double[][] getTheOwnValues() {
        return this.vals;
    }

    public double getTheZeroValue() {
        return this.zeroVal;
    }

    public boolean setFunctionString(String string, IDElement[] iDElementArray) {
        int n;
        int n2;
        char c;
        boolean bl = true;
        this.ownValues = false;
        this.vals = null;
        this.zeroVal = 0.0;
        IDElement[] iDElementArray2 = this.ids;
        String[] stringArray = this.stringteile;
        int n3 = this.ids_pos;
        int n4 = this.ids_len;
        int n5 = this.stringteile_pos;
        int n6 = this.stringteile_len;
        IFunction iFunction = this.function;
        this.resetArrays();
        StringBuffer stringBuffer = new StringBuffer();
        int n7 = 0;
        while (n7 < string.length()) {
            c = string.charAt(n7);
            if (c != '\"') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('\'');
            }
            ++n7;
        }
        string = stringBuffer.toString();
        this.nameParse(string, iDElementArray, 0);
        int n8 = 0;
        int n9 = 0;
        while (n9 < string.length()) {
            c = string.charAt(n9);
            if (c == '(') {
                ++n8;
            }
            if (c == ')') {
                --n8;
            }
            if (n8 < 0) {
                MessageDialog messageDialog = new MessageDialog(this.getModelElement().getFrame(), "Warnung", true);
                messageDialog.show("Sie haben mehr Klammern geschlossen als ge\u00f6ffnet.\nWas wollen Sie tun?\n", "FUNKTION VERWERFEN", "FUNKTION NEU BEARBEITEN", "TROTZDEM \u00dcBERNEHMEN");
                int n10 = messageDialog.getAnswer();
                switch (n10) {
                    case 0: {
                        this.ids = iDElementArray2;
                        this.stringteile = stringArray;
                        this.ids_pos = n3;
                        this.ids_len = n4;
                        this.stringteile_pos = n5;
                        this.stringteile_len = n6;
                        this.function = iFunction;
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
                return true;
            }
            ++n9;
        }
        if (n8 > 0) {
            MessageDialog messageDialog = new MessageDialog(this.getModelElement().getFrame(), "Warnung", true);
            messageDialog.show("Sie haben mehr Klammern ge\u00f6ffnet als geschlossen.\nWas wollen Sie tun?\n", "FUNKTION VERWERFEN", "FUNKTION NEU BEARBEITEN", "TROTZDEM \u00dcBERNEHMEN");
            int n11 = messageDialog.getAnswer();
            switch (n11) {
                case 0: {
                    this.ids = iDElementArray2;
                    this.stringteile = stringArray;
                    this.ids_pos = n3;
                    this.ids_len = n4;
                    this.stringteile_pos = n5;
                    this.stringteile_len = n6;
                    this.function = iFunction;
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return true;
        }
        boolean bl2 = true;
        int n12 = 0;
        while (n12 < iDElementArray.length && bl2) {
            bl2 = false;
            n2 = 0;
            while (n2 < this.ids_pos) {
                if (this.ids[n2] == iDElementArray[n12]) {
                    bl2 = true;
                }
                ++n2;
            }
            ++n12;
        }
        if (bl2) {
            n2 = 0;
            while (n2 < this.ids_pos && bl2) {
                bl2 = false;
                n = 0;
                while (n < iDElementArray.length) {
                    if (this.ids[n2] == iDElementArray[n]) {
                        bl2 = true;
                    }
                    ++n;
                }
                ++n2;
            }
        }
        if (!bl2) {
            MessageDialog messageDialog = new MessageDialog(this.getModelElement().getFrame(), "Warnung", true);
            messageDialog.show("In Ihrer Funktion haben Sie nicht alle verkn\u00fcpften Elemente ber\u00fccksichtigt.\nWas wollen Sie tun?\n", "FUNKTION VERWERFEN", "FUNKTION NEU BEARBEITEN", "TROTZDEM \u00dcBERNEHMEN");
            n = messageDialog.getAnswer();
            switch (n) {
                case 0: {
                    this.ids = iDElementArray2;
                    this.stringteile = stringArray;
                    this.ids_pos = n3;
                    this.ids_len = n4;
                    this.stringteile_pos = n5;
                    this.stringteile_len = n6;
                    this.function = iFunction;
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return true;
        }
        Parser.getStandardParser().parse(this);
        if (this.function instanceof FUnparsable) {
            this.mef.setValid(false);
            MessageDialog messageDialog = new MessageDialog(this.getModelElement().getFrame(), "Warnung", true);
            messageDialog.show("Der Parser konnte Ihre Funktion nicht auswerten.\nBitte beachten Sie unten die Meldungen, um den Grund daf\u00fcr zu erfahren.\nWas wollen Sie tun?", "FUNKTION VERWERFEN", "FUNKTION NEU BEARBEITEN", "TROTZDEM \u00dcBERNEHMEN");
            n = messageDialog.getAnswer();
            switch (n) {
                case 0: {
                    this.ids = iDElementArray2;
                    this.stringteile = stringArray;
                    this.ids_pos = n3;
                    this.ids_len = n4;
                    this.stringteile_pos = n5;
                    this.stringteile_len = n6;
                    this.function = iFunction;
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private int nameIndex(String string, String string2, int n) {
        int n2 = string.indexOf(string2, n);
        if (n2 >= 0) {
            char c;
            if (n2 > 0 && (Character.isLetter(c = string.charAt(n2 - 1)) || Character.isDigit(c) || c == '_')) {
                return this.nameIndex(string, string2, n2 + 1);
            }
            if (n2 + string2.length() < string.length() && (Character.isLetter(c = string.charAt(n2 + string2.length())) || Character.isDigit(c) || c == '_')) {
                return this.nameIndex(string, string2, n2 + 1);
            }
        }
        return n2;
    }

    private void nameParse(String string, IDElement[] iDElementArray, int n) {
        int n2 = -1;
        int n3 = n;
        while (n2 == -1 && n3 < iDElementArray.length) {
            n2 = this.nameIndex(string, iDElementArray[n3].getName(), 0);
            ++n3;
        }
        if (n2 > -1) {
            this.nameParse(string.substring(0, n2), iDElementArray, --n3 + 1);
            this.addIDTeil(iDElementArray[n3]);
            this.nameParse(string.substring(n2 + iDElementArray[n3].getName().length()), iDElementArray, n3);
        } else {
            this.addStringTeil(string);
        }
    }

    public String getHumanString() {
        if (!this.ownValues) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.stringteile[0]);
            int n = 1;
            while (n < this.stringteile_pos) {
                stringBuffer.append(this.ids[n - 1].getName());
                stringBuffer.append(this.stringteile[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
        return "Eigene Werte";
    }

    public String getParserString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.stringteile[0]);
        int n = 1;
        while (n < this.stringteile_pos) {
            stringBuffer.append("$E");
            stringBuffer.append(this.ids[n - 1].getId());
            stringBuffer.append("$");
            stringBuffer.append(this.stringteile[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void doValidation() {
        EConnection[] eConnectionArray = this.mef.getModel().getConnectionArray().getAllTo(this.mef.getId());
        if (!this.ownValues) {
            if (this.stringteile_pos == 1 && this.stringteile[0].length() == 0) {
                this.mef.setValid(false);
            } else {
                int n;
                boolean bl;
                int n2 = 0;
                while (n2 < this.ids_pos) {
                    bl = false;
                    n = 0;
                    while (n < eConnectionArray.length && !bl) {
                        if (this.ids[n2] == eConnectionArray[n].getFrom()) {
                            bl = true;
                        }
                        ++n;
                    }
                    if (!bl) {
                        this.mef.setValid(false);
                    }
                    ++n2;
                }
                n = 0;
                while (n < eConnectionArray.length) {
                    bl = false;
                    int n3 = 0;
                    while (n3 < this.ids_pos && !bl) {
                        if (this.ids[n3] == eConnectionArray[n].getFrom()) {
                            bl = true;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        this.mef.setValid(false);
                    }
                    ++n;
                }
            }
            if (this.mef.isValid()) {
                if (this.function == null) {
                    Parser.getStandardParser().parse(this);
                }
                if (this.function instanceof FUnparsable) {
                    this.mef.setValid(false);
                }
            } else {
                this.function = null;
            }
        } else {
            if (eConnectionArray.length > 0) {
                this.mef.setValid(false);
            }
            if (this.vals == null || this.vals.length < 2) {
                this.mef.setValid(false);
            }
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.ownValues);
        if (!this.ownValues) {
            dataOutputStream.writeInt(this.stringteile_pos);
            int n = 0;
            while (n < this.stringteile_pos - 1) {
                dataOutputStream.writeChars("\"");
                dataOutputStream.writeChars(this.stringteile[n]);
                dataOutputStream.writeChars("\"");
                dataOutputStream.writeInt(this.ids[n].getId());
                ++n;
            }
            dataOutputStream.writeChars("\"");
            dataOutputStream.writeChars(this.stringteile[this.stringteile_pos - 1]);
            dataOutputStream.writeChars("\"");
        } else {
            dataOutputStream.writeInt(this.vals.length);
            int n = 0;
            while (n < this.vals.length) {
                dataOutputStream.writeDouble(this.vals[n][0]);
                dataOutputStream.writeDouble(this.vals[n][1]);
                ++n;
            }
            dataOutputStream.writeDouble(this.zeroVal);
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.ownValues = dataInputStream.readBoolean();
        if (!this.ownValues) {
            char c;
            this.stringteile_len = this.stringteile_pos = dataInputStream.readInt();
            this.ids_pos = this.stringteile_pos - 1;
            this.ids_len = this.stringteile_len;
            this.stringteile = new String[this.stringteile_len];
            this.ids = new IDElement[this.ids_len];
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.stringteile_pos - 1) {
                c = dataInputStream.readChar();
                stringBuffer.setLength(0);
                while ((c = dataInputStream.readChar()) != '\"') {
                    stringBuffer.append(c);
                }
                this.stringteile[n] = stringBuffer.toString();
                this.ids[n] = this.mef.getModel().getModelFolder().getIdHandler().getIdElement(dataInputStream.readInt());
                ++n;
            }
            c = dataInputStream.readChar();
            stringBuffer.setLength(0);
            while ((c = dataInputStream.readChar()) != '\"') {
                stringBuffer.append(c);
            }
            this.stringteile[this.stringteile_pos - 1] = stringBuffer.toString();
        } else {
            int n = dataInputStream.readInt();
            this.vals = new double[n][2];
            int n2 = 0;
            while (n2 < n) {
                this.vals[n2][0] = dataInputStream.readDouble();
                this.vals[n2][1] = dataInputStream.readDouble();
                ++n2;
            }
            this.zeroVal = dataInputStream.readDouble();
            this.setOwnValues(this.vals, this.zeroVal);
        }
    }
}

