/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.EState;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.ModelElementFunction;
import frei_benno.dynamic.model.graphic.EFlowPanel;
import frei_benno.dynamic.model.graphic.ModelElementPanel;
import frei_benno.dynamic.model.id.IDElement;
import frei_benno.dynamic.toolkit.ArcCalculator;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EFlow
extends ModelElementFunction
implements IDrawable2D {
    public static final double FLOW_WIDTH = 30.0;
    public static final double FLOW_HEIGHT = 30.0;
    private IDElement from;
    private IDElement to;
    private Point2D.Double start = new Point2D.Double(0.0, 0.0);
    private Point2D.Double stop = new Point2D.Double(1.0, 1.0);
    private GeneralPath symbol = new GeneralPath();
    private Rectangle2D.Double flowerLoc = new Rectangle2D.Double();
    private static final double abst_kreis_aussen = 9.0;
    private static final double radius = 6.0;
    private static final double COSI = Math.cos(0.7853981633974483) * 8.0;
    private boolean allesverknuepft = false;
    private boolean rechts = false;
    private static final double blumen_rad = 16.0;
    private Arc2D.Double blume1;
    private Arc2D.Double blume2;
    private Arc2D.Double blume3;
    private Arc2D.Double blume4;
    private Arc2D.Double blume5;
    private static final double hrb = 2.5;
    private static final double spitzlaenge = 18.0;
    private static final double spitzbreite = 12.0;
    private int[] x_from;
    private int[] y_from;
    private int[] x_to;
    private int[] y_to;
    private Polygon poly_from;
    private Polygon poly_to;
    private GeneralPath pfad_from;
    private GeneralPath pfad_to;
    private boolean moving;
    private EState fromState;
    private EState toState;

    public EFlow(Model model) {
        super(model);
        this.blume1 = new Arc2D.Double(this.centre.x, this.centre.y, 16.0, 16.0, 0.0, 270.0, 0);
        this.blume2 = new Arc2D.Double(this.centre.x, this.centre.y, 16.0, 16.0, -90.0, 270.0, 0);
        this.blume3 = new Arc2D.Double(this.centre.x, this.centre.y, 16.0, 16.0, -180.0, 270.0, 0);
        this.blume4 = new Arc2D.Double(this.centre.x, this.centre.y, 16.0, 16.0, 90.0, 270.0, 0);
        this.blume5 = new Arc2D.Double(this.centre.x, this.centre.y, 16.0, 16.0, 0.0, 360.0, 0);
        this.x_from = new int[4];
        this.y_from = new int[4];
        this.x_to = new int[7];
        this.y_to = new int[7];
        this.poly_from = new Polygon();
        this.poly_to = new Polygon();
        this.pfad_from = new GeneralPath();
        this.pfad_to = new GeneralPath();
        this.moving = false;
        this.fromState = null;
        this.toState = null;
        this.setValid(false);
    }

    public double getWidth() {
        return 30.0;
    }

    public double getHeight() {
        return 30.0;
    }

    public void setFrom(IDElement iDElement) {
        this.from = iDElement;
        if (iDElement == null) {
            this.start = new Point2D.Double();
        }
    }

    public void setTo(IDElement iDElement) {
        this.to = iDElement;
        if (iDElement == null) {
            this.stop = new Point2D.Double();
        }
    }

    public IDElement getFrom() {
        return this.from;
    }

    public IDElement getTo() {
        return this.to;
    }

    public void setPosition(double d, double d2) {
        super.setPosition(d, d2);
        this.recalculateCoordinates();
    }

    public boolean isEmptyFlow() {
        return !(this.to != null && this.to.isActivated() || this.from != null && this.from.isActivated());
    }

    protected ModelElementPanel constructSpecificPanel() {
        return new EFlowPanel();
    }

    public void setStartingValues(Point2D.Double double_, Point2D.Double double_2) {
        this.start.x = double_.x;
        this.start.y = double_.y;
        this.stop.x = double_2.x;
        this.stop.y = double_2.y;
        this.setPosition(double_.x + (double_2.x - double_.x - 30.0) / 2.0, double_.y + (double_2.y - double_.y - 30.0) / 2.0);
    }

    public void recalculateCoordinates() {
        this.allesverknuepft = false;
        if (this.from != null && this.to != null) {
            this.start = ((EState)this.from.getOwner()).getCentre();
            this.stop = ((EState)this.to.getOwner()).getConnectionPoint2D(this.pos);
            this.allesverknuepft = true;
        }
        if (this.from == null) {
            this.stop = ((EState)this.to.getOwner()).getConnectionPoint2D(this.pos);
            this.start.y = this.getCentreY();
            if (this.centre.x < this.stop.x) {
                this.start.x = this.getCentreX() - 100.0;
                this.rechts = false;
            } else {
                this.start.x = this.getCentreX() + 100.0;
                this.rechts = true;
            }
        }
        if (this.to == null) {
            this.start = ((EState)this.from.getOwner()).getCentre();
            this.stop.y = this.getCentreY();
            if (this.centre.x < this.start.x) {
                this.stop.x = this.getCentreX() - 100.0;
                this.rechts = false;
            } else {
                this.stop.x = this.getCentreX() + 100.0;
                this.rechts = true;
            }
        }
        this.symbol.reset();
        this.symbol.moveTo((float)this.loc.x, (float)this.loc.y);
        this.symbol.lineTo((float)(this.loc.x + this.loc.width), (float)this.loc.y);
        this.symbol.lineTo((float)this.loc.x, (float)(this.loc.y + this.loc.height));
        this.symbol.lineTo((float)(this.loc.x + this.loc.width), (float)(this.loc.y + this.loc.height));
        this.symbol.closePath();
        if (!this.allesverknuepft) {
            if (this.rechts) {
                if (this.from == null) {
                    this.blume1.x = this.start.x;
                    this.blume1.y = this.start.y - 16.0;
                    this.blume2.x = this.start.x + 16.0;
                    this.blume2.y = this.start.y - 16.0;
                    this.blume3.x = this.start.x + 16.0;
                    this.blume3.y = this.start.y;
                    this.blume4.x = this.start.x;
                    this.blume4.y = this.start.y;
                    this.blume5.x = this.start.x + 8.0;
                    this.blume5.y = this.start.y - 8.0;
                } else {
                    this.blume1.x = this.stop.x;
                    this.blume1.y = this.stop.y - 16.0;
                    this.blume2.x = this.stop.x + 16.0;
                    this.blume2.y = this.stop.y - 16.0;
                    this.blume3.x = this.stop.x + 16.0;
                    this.blume3.y = this.stop.y;
                    this.blume4.x = this.stop.x;
                    this.blume4.y = this.stop.y;
                    this.blume5.x = this.stop.x + 8.0;
                    this.blume5.y = this.stop.y - 8.0;
                }
            } else if (this.from == null) {
                this.blume1.x = this.start.x - 32.0;
                this.blume1.y = this.start.y - 16.0;
                this.blume2.x = this.start.x - 16.0;
                this.blume2.y = this.start.y - 16.0;
                this.blume3.x = this.start.x - 16.0;
                this.blume3.y = this.start.y;
                this.blume4.x = this.start.x - 32.0;
                this.blume4.y = this.start.y;
                this.blume5.x = this.start.x - 24.0;
                this.blume5.y = this.start.y - 8.0;
            } else {
                this.blume1.x = this.stop.x - 32.0;
                this.blume1.y = this.stop.y - 16.0;
                this.blume2.x = this.stop.x - 16.0;
                this.blume2.y = this.stop.y - 16.0;
                this.blume3.x = this.stop.x - 16.0;
                this.blume3.y = this.stop.y;
                this.blume4.x = this.stop.x - 32.0;
                this.blume4.y = this.stop.y;
                this.blume5.x = this.stop.x - 24.0;
                this.blume5.y = this.stop.y - 8.0;
            }
            this.flowerLoc.x = this.blume1.x;
            this.flowerLoc.y = this.blume1.y;
            this.flowerLoc.width = 32.0;
            this.flowerLoc.height = 32.0;
        } else {
            this.flowerLoc.x = this.centre.x;
            this.flowerLoc.y = this.centre.y;
            this.flowerLoc.width = 1.0;
            this.flowerLoc.height = 1.0;
        }
        this.flowerLoc.add(this.loc);
        double d = Math.sqrt((this.centre.x - this.start.x) * (this.centre.x - this.start.x) + (this.centre.y - this.start.y) * (this.centre.y - this.start.y));
        double d2 = (this.centre.x - this.start.x) / d;
        double d3 = (this.centre.y - this.start.y) / d;
        this.pfad_from.reset();
        this.pfad_from.moveTo((float)(this.start.x + 2.5 * d3), (float)(this.start.y - 2.5 * d2));
        this.x_from[0] = (int)(this.start.x + 2.5 * d3);
        this.y_from[0] = (int)(this.start.y - 2.5 * d2);
        this.pfad_from.lineTo((float)(this.centre.x + 2.5 * d3), (float)(this.centre.y - 2.5 * d2));
        this.x_from[1] = (int)(this.centre.x + 2.5 * d3);
        this.y_from[1] = (int)(this.centre.y - 2.5 * d2);
        this.pfad_from.lineTo((float)(this.centre.x - 2.5 * d3), (float)(this.centre.y + 2.5 * d2));
        this.x_from[2] = (int)(this.centre.x - 2.5 * d3);
        this.y_from[2] = (int)(this.centre.y + 2.5 * d2);
        this.pfad_from.lineTo((float)(this.start.x - 2.5 * d3), (float)(this.start.y + 2.5 * d2));
        this.x_from[3] = (int)(this.start.x - 2.5 * d3);
        this.y_from[3] = (int)(this.start.y + 2.5 * d2);
        this.pfad_from.closePath();
        this.poly_from.xpoints = this.x_from;
        this.poly_from.ypoints = this.y_from;
        this.poly_from.npoints = 4;
        d = Math.sqrt((this.centre.x - this.stop.x) * (this.centre.x - this.stop.x) + (this.centre.y - this.stop.y) * (this.centre.y - this.stop.y));
        d2 = (this.stop.x - this.centre.x) / d;
        d3 = (this.stop.y - this.centre.y) / d;
        this.pfad_to.reset();
        this.pfad_to.moveTo((float)(this.centre.x + 2.5 * d3), (float)(this.centre.y - 2.5 * d2));
        this.x_to[0] = (int)(this.centre.x + 2.5 * d3);
        this.y_to[0] = (int)(this.centre.y - 2.5 * d2);
        this.pfad_to.lineTo((float)(this.stop.x - 18.0 * d2 + 2.5 * d3), (float)(this.stop.y - 18.0 * d3 - 2.5 * d2));
        this.x_to[1] = (int)(this.stop.x - 18.0 * d2 + 2.5 * d3);
        this.y_to[1] = (int)(this.stop.y - 18.0 * d3 - 2.5 * d2);
        this.pfad_to.lineTo((float)(this.stop.x - 18.0 * d2 + 6.0 * d3), (float)(this.stop.y - 18.0 * d3 - 6.0 * d2));
        this.x_to[2] = (int)(this.stop.x - 18.0 * d2 + 6.0 * d3);
        this.y_to[2] = (int)(this.stop.y - 18.0 * d3 - 6.0 * d2);
        this.pfad_to.lineTo((float)this.stop.x, (float)this.stop.y);
        this.x_to[3] = (int)this.stop.x;
        this.y_to[3] = (int)this.stop.y;
        this.pfad_to.lineTo((float)(this.stop.x - 18.0 * d2 - 6.0 * d3), (float)(this.stop.y - 18.0 * d3 + 6.0 * d2));
        this.x_to[4] = (int)(this.stop.x - 18.0 * d2 - 6.0 * d3);
        this.y_to[4] = (int)(this.stop.y - 18.0 * d3 + 6.0 * d2);
        this.pfad_to.lineTo((float)(this.stop.x - 18.0 * d2 - 2.5 * d3), (float)(this.stop.y - 18.0 * d3 + 2.5 * d2));
        this.x_to[5] = (int)(this.stop.x - 18.0 * d2 - 2.5 * d3);
        this.y_to[5] = (int)(this.stop.y - 18.0 * d3 + 2.5 * d2);
        this.pfad_to.lineTo((float)(this.centre.x - 2.5 * d3), (float)(this.centre.y + 2.5 * d2));
        this.x_to[6] = (int)(this.centre.x - 2.5 * d3);
        this.y_to[6] = (int)(this.centre.y + 2.5 * d2);
        this.pfad_to.closePath();
        this.poly_to.xpoints = this.x_to;
        this.poly_to.ypoints = this.y_to;
        this.poly_to.npoints = 7;
    }

    public Rectangle2D.Double getTotalLocation() {
        return this.flowerLoc;
    }

    public Point2D.Double getConnectionPoint2D(Point2D.Double double_) {
        if (double_.y > this.loc.y + this.loc.height) {
            Rectangle2D.Double double_2 = new Rectangle2D.Double(this.loc.x, this.loc.y + this.loc.height - 0.01, this.loc.width, 0.01);
            return ArcCalculator.getRectLineIntersection(double_2, double_);
        }
        Rectangle2D.Double double_3 = new Rectangle2D.Double(this.loc.x, this.loc.y, this.loc.width, this.loc.height * 2.0);
        return ArcCalculator.getRectLineIntersection(double_3, double_);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        graphics2D.setColor(ModelElement.backgroundColor);
        graphics2D.fill(this.pfad_from);
        graphics2D.fill(this.pfad_to);
        graphics2D.setColor(ModelElement.standardColor);
        graphics2D.draw(this.pfad_from);
        graphics2D.draw(this.pfad_to);
        if (!this.allesverknuepft) {
            graphics2D.draw(this.blume5);
            graphics2D.draw(this.blume1);
            graphics2D.draw(this.blume2);
            graphics2D.draw(this.blume3);
            graphics2D.draw(this.blume4);
        }
        graphics2D.setColor(ModelElement.backgroundColor);
        graphics2D.fill(this.symbol);
        if (this.mouseOver) {
            graphics2D.setColor(ModelElement.mouseOverColor);
        } else {
            graphics2D.setColor(ModelElement.standardColor);
        }
        graphics2D.draw(this.symbol);
        graphics2D.setColor(ModelElement.fontColor);
        graphics2D.setFont(ModelElement.standardFont);
        graphics2D.drawString(this.id.getName(), (float)(this.centre.x - (double)(graphics2D.getFontMetrics().stringWidth(this.id.getName()) / 2)), (float)(this.loc.y + 30.0 + 1.0 + 12.0));
        if (!this.isValid()) {
            this.drawInvalidSymbol(graphics2D, this.centre);
        }
    }

    public void markAsMoving() {
        this.moving = true;
    }

    public void confirmFlowMoving() {
        if (this.moving) {
            this.recalculateCoordinates();
            this.moving = false;
        }
    }

    public void doValidation() {
        this.setValid(true);
        this.functionString.doValidation();
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        if (this.from == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(this.from.getId());
        }
        if (this.to == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(this.to.getId());
        }
        dataOutputStream.writeDouble(this.loc.x);
        dataOutputStream.writeDouble(this.loc.y);
        this.functionString.save(dataOutputStream);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.id = this.model.getModelFolder().getIdHandler().loadId(n, this);
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        if (n2 >= 0) {
            this.setFrom(this.model.getModelFolder().getIdHandler().getIdElement(n2));
        } else {
            this.setFrom(null);
        }
        if (n3 >= 0) {
            this.setTo(this.model.getModelFolder().getIdHandler().getIdElement(n3));
        } else {
            this.setTo(null);
        }
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        this.setPosition(d, d2);
        this.functionString.load(dataInputStream);
    }

    public void activateSimulation() {
        if (this.from != null) {
            this.fromState = (EState)this.from.getOwner();
        }
        if (this.to != null) {
            this.toState = (EState)this.to.getOwner();
        }
    }

    public void deactivateSimulation() {
        this.fromState = null;
        this.toState = null;
    }

    public void letItFlow(double d) {
        if (this.fromState != null) {
            this.fromState.outFlow(d * this.value);
        }
        if (this.toState != null) {
            this.toState.inFlow(d * this.value);
        }
    }

    public void setGradient() {
        if (this.fromState != null) {
            this.fromState.outGradient(this.value);
        }
        if (this.toState != null) {
            this.toState.inGradient(this.value);
        }
    }
}

