/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.ModelFile;
import frei_benno.dynamic.model.id.IDElement;
import frei_benno.dynamic.toolkit.BerichtPrinter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class Bericht
implements IDrawable2D,
Printable {
    private StringBuffer bericht = new StringBuffer();
    private IDElement id;
    private ModelFile modelFile;
    private JTextArea text;
    private boolean printCalculated = false;
    private BerichtPrinter bp;

    public Bericht(ModelFile modelFile) {
        this.modelFile = modelFile;
        this.id = modelFile.getIdHandler().createNewID("BERICHT", this);
    }

    public ModelFile getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(ModelFile modelFile) {
        this.modelFile = modelFile;
    }

    public IDElement getId() {
        return this.id;
    }

    public String toString() {
        return "  " + this.id.getName();
    }

    public void printContent() {
        block4: {
            PageFormat pageFormat;
            PrinterJob printerJob;
            PageFormat pageFormat2;
            if (this.text != null) {
                this.setText(this.text.getText());
            }
            if ((pageFormat2 = (printerJob = PrinterJob.getPrinterJob()).pageDialog(pageFormat = printerJob.defaultPage())) == pageFormat) break block4;
            printerJob.setPrintable(this, pageFormat2);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.printCalculated) {
            this.bp = new BerichtPrinter();
            this.bp.init(this, graphics2D, pageFormat);
            this.printCalculated = true;
        }
        return this.bp.print(graphics2D, pageFormat, n);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        if (this.text != null) {
            this.setText(this.text.getText());
        }
        dataOutputStream.writeInt(this.bericht.length());
        dataOutputStream.writeChars(this.bericht.toString());
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.id = this.modelFile.getIdHandler().loadId(dataInputStream.readInt(), this);
        this.bericht.setLength(0);
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.bericht.append(dataInputStream.readChar());
            ++n2;
        }
        if (this.text != null) {
            this.text.setText(this.bericht.toString());
        }
    }

    public void setText(String string) {
        this.bericht.setLength(0);
        this.bericht.append(string);
        this.text.setText(this.bericht.toString());
    }

    public String getText() {
        return this.bericht.toString();
    }

    public void setTextArea(JTextArea jTextArea) {
        if (this.text != null) {
            this.bericht.setLength(0);
            this.bericht.append(this.text.getText());
        }
        this.text = jTextArea;
        this.text.setText(this.bericht.toString());
    }

    public void removeTextArea() {
        this.bericht.setLength(0);
        this.bericht.append(this.text.getText());
        this.text = null;
    }

    public JTextArea getTextArea() {
        return this.text;
    }
}

