/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.math;

import frei_benno.dynamic.formula.math.Function;
import frei_benno.dynamic.formula.math.IFunction;

public abstract class Function2
extends Function {
    protected double lasttermval1;
    protected double lasttermval2;
    protected double lastownval;
    protected IFunction term1;
    protected IFunction term2;
    protected boolean initialized;

    public Function2() {
        this(null, null);
    }

    public Function2(IFunction iFunction, IFunction iFunction2) {
        this.term1 = iFunction;
        this.term2 = iFunction2;
        this.lastownval = 0.0;
        this.lasttermval1 = 0.0;
        this.lasttermval2 = 0.0;
        this.initialized = false;
    }

    public void setTerm(IFunction iFunction, IFunction iFunction2) {
        this.term1 = iFunction;
        this.term2 = iFunction2;
        this.lastownval = 0.0;
        this.lasttermval1 = 0.0;
        this.lasttermval2 = 0.0;
        this.initialized = false;
    }

    public double eval() {
        if (this.term1 != null && this.term2 != null) {
            double d = this.term1.eval();
            double d2 = this.term2.eval();
            if (!this.initialized || d != this.lasttermval1 || d2 != this.lasttermval2) {
                this.initialized = true;
                this.lasttermval1 = d;
                this.lasttermval2 = d2;
                this.lastownval = this.operation(this.lasttermval1, this.lasttermval2);
                if (Double.isInfinite(this.lastownval)) {
                    // empty if block
                }
                if (Double.isNaN(this.lastownval)) {
                    // empty if block
                }
            }
            return this.lastownval;
        }
        return 0.0;
    }

    protected abstract double operation(double var1, double var3);

    public String writeFunction() {
        return this.className() + "(" + this.term1.writeFunction() + "," + this.term2.writeFunction() + ")";
    }
}

