/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model.array;

import frei_benno.dynamic.formula.math.FConstant;
import frei_benno.dynamic.formula.math.FNegative;
import frei_benno.dynamic.model.EIntermediateValue;
import frei_benno.dynamic.model.IDrawable;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.array.IElementArray;
import java.awt.Graphics2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EIntermediateValueArray
implements IElementArray,
IDrawable,
IDrawable2D {
    private static final int INITIAL_SIZE = 10;
    private static final int INCREMENT = 5;
    private Model model;
    private EIntermediateValue[] arr;
    private int arr_size;
    private int arr_pos;

    public EIntermediateValueArray(Model model) {
        this.model = model;
        this.arr_size = 10;
        this.arr_pos = 0;
        this.arr = new EIntermediateValue[this.arr_size];
    }

    public EIntermediateValue[] getConstants() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.arr_pos) {
            if (this.arr[n2].getFunction() instanceof FConstant || this.arr[n2].getFunction() instanceof FNegative && ((FNegative)this.arr[n2].getFunction()).isConstant()) {
                ++n;
            }
            ++n2;
        }
        EIntermediateValue[] eIntermediateValueArray = new EIntermediateValue[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.arr_pos) {
            if (this.arr[n3].getFunction() instanceof FConstant || this.arr[n3].getFunction() instanceof FNegative && ((FNegative)this.arr[n3].getFunction()).isConstant()) {
                eIntermediateValueArray[n++] = this.arr[n3];
            }
            ++n3;
        }
        return eIntermediateValueArray;
    }

    private void incrementArraySize() {
        this.arr_size += 5;
        EIntermediateValue[] eIntermediateValueArray = new EIntermediateValue[this.arr_size];
        System.arraycopy(this.arr, 0, eIntermediateValueArray, 0, this.arr_pos);
        this.arr = eIntermediateValueArray;
    }

    public void addElement(EIntermediateValue eIntermediateValue) {
        if (this.arr_pos >= this.arr_size) {
            this.incrementArraySize();
        }
        eIntermediateValue.setArray(this);
        this.arr[this.arr_pos++] = eIntermediateValue;
    }

    public EIntermediateValue getElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            return this.arr[n];
        }
        return null;
    }

    public int length() {
        return this.arr_pos;
    }

    public void removeElement(EIntermediateValue eIntermediateValue) {
        int n = 0;
        while (n < this.arr_pos && this.arr[n] != eIntermediateValue) {
            ++n;
        }
        this.removeElement(n);
    }

    public void removeElement(int n) {
        if (n >= 0 && n < this.arr_pos) {
            this.arr[n] = this.arr[--this.arr_pos];
            this.arr[this.arr_pos] = null;
        }
    }

    public void removeElement(Object object) {
        this.removeElement((EIntermediateValue)object);
    }

    public void removeMarks() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].setMarked(false);
            ++n;
        }
    }

    public EIntermediateValue createNewIntermediateValue() {
        EIntermediateValue eIntermediateValue = new EIntermediateValue(this.model);
        this.addElement(eIntermediateValue);
        return eIntermediateValue;
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].draw2D(graphics2D, jComponent);
            ++n;
        }
    }

    public void doValidation() {
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].doValidation();
            ++n;
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.arr_pos);
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n].save(dataOutputStream);
            ++n;
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.arr_size = this.arr_pos = dataInputStream.readInt();
        this.arr = new EIntermediateValue[this.arr_size];
        int n = 0;
        while (n < this.arr_pos) {
            this.arr[n] = new EIntermediateValue(this.model);
            this.arr[n].load(dataInputStream);
            this.arr[n].setArray(this);
            ++n;
        }
    }

    public EIntermediateValue[] getAll() {
        EIntermediateValue[] eIntermediateValueArray = new EIntermediateValue[this.arr_pos];
        System.arraycopy(this.arr, 0, eIntermediateValueArray, 0, this.arr_pos);
        return eIntermediateValueArray;
    }

    public boolean isValid() {
        boolean bl = true;
        int n = 0;
        while (n < this.arr_pos && bl) {
            bl &= this.arr[n].isValid();
            ++n;
        }
        return bl;
    }
}

