/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.formula.numeric.SimProperties;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.id.IDElement;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.table.AbstractTableModel;

public class Simulation
extends AbstractTableModel {
    private static final String strClass = "";
    private IDElement id;
    private Model model;
    private SimProperties simProperties;
    private IDElement[] ids;
    private double[][] values;
    Class cls = new Double(0.0).getClass();

    public Simulation(Model model) {
        this.model = model;
        this.id = model.getModelFolder().getIdHandler().createNewID("SIMULATION", this);
        this.simProperties = new SimProperties();
        this.ids = new IDElement[0];
        this.values = new double[0][0];
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public IDElement getId() {
        return this.id;
    }

    public void refresh() {
        this.fireTableStructureChanged();
    }

    public void simulate() {
        this.simProperties.simulate(this.model, this);
    }

    public void setIDList(IDElement[] iDElementArray) {
        this.ids = iDElementArray;
    }

    public void setValuesList(double[][] dArray) {
        this.values = dArray;
    }

    public IDElement[] getIDList() {
        return this.ids;
    }

    public IDElement[] getIDListTimeless() {
        IDElement[] iDElementArray = new IDElement[this.ids.length - 1];
        int n = 0;
        while (n < iDElementArray.length) {
            iDElementArray[n] = this.ids[n + 1];
            ++n;
        }
        return iDElementArray;
    }

    public double[] getTimeAxe() {
        return this.values[0];
    }

    public double[] getElementValues(IDElement iDElement) {
        double[] dArray = null;
        int n = 0;
        while (n < this.ids.length && dArray == null) {
            if (this.ids[n] == iDElement) {
                dArray = this.values[n];
            }
            ++n;
        }
        return dArray;
    }

    public int getRowCount() {
        if (this.values.length > 0) {
            return this.values[0].length;
        }
        return 0;
    }

    public int getColumnCount() {
        return this.ids.length;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Zeit";
        }
        return this.ids[n].getName();
    }

    public Class getColumnClass(int n) {
        return this.cls;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        return new Double(this.values[n2][n]);
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            double d;
            Double d2 = new Double((String)object);
            this.values[n2][n] = d = d2.doubleValue();
        }
        catch (Exception exception) {}
    }

    public SimProperties getSimProperties() {
        return this.simProperties;
    }

    public void setSimProperties(SimProperties simProperties) {
        this.simProperties = simProperties;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.id = this.getModel().getModelFolder().getIdHandler().loadId(n, this);
        this.simProperties.load(dataInputStream);
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        this.simProperties.save(dataOutputStream);
    }

    public String toString() {
        return this.id.getName();
    }

    public void copyContent(int[] nArray, int[] nArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray2.length) {
            stringBuffer.append(this.getColumnName(nArray2[n]));
            if (n < nArray2.length - 1) {
                stringBuffer.append('\t');
            }
            ++n;
        }
        stringBuffer.append('\n');
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray2.length) {
                stringBuffer.append(this.values[nArray2[n3]][nArray[n2]]);
                if (n3 < nArray2.length - 1) {
                    stringBuffer.append('\t');
                }
                ++n3;
            }
            stringBuffer.append('\n');
            ++n2;
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }
}

