/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.formula.numeric.Simulator;
import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.EConnection;
import frei_benno.dynamic.model.EFlow;
import frei_benno.dynamic.model.EIntermediateValue;
import frei_benno.dynamic.model.EState;
import frei_benno.dynamic.model.IDrawable;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.ModelElementFunction;
import frei_benno.dynamic.model.ModelFolder;
import frei_benno.dynamic.model.array.EConnectionArray;
import frei_benno.dynamic.model.array.EFlowArray;
import frei_benno.dynamic.model.array.EIntermediateValueArray;
import frei_benno.dynamic.model.array.EStateArray;
import frei_benno.dynamic.model.array.ModelElementPanelArray;
import frei_benno.dynamic.model.graphic.ModelElementPanel;
import frei_benno.dynamic.model.graphic.ModelPanel;
import frei_benno.dynamic.model.graphic.ModelPanelInside;
import frei_benno.dynamic.model.id.IDElement;
import frei_benno.dynamic.toolkit.SystemClipboard;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class Model
implements IDrawable,
IDrawable2D,
Printable {
    private ModelFolder modelFolder;
    private EConnectionArray connArr;
    private EFlowArray flowArr;
    private EStateArray stateArr;
    private EIntermediateValueArray interArr;
    private double time;
    private ModelPanelInside mpi;
    private ModelElementPanelArray mepArr;
    private int tool = 0;
    private ModelPanel modelPanel;
    private Simulator simulator;

    public Model(ModelFolder modelFolder) {
        this.modelFolder = modelFolder;
        this.connArr = new EConnectionArray(this);
        this.flowArr = new EFlowArray(this);
        this.stateArr = new EStateArray(this);
        this.interArr = new EIntermediateValueArray(this);
        this.mepArr = new ModelElementPanelArray();
        this.mpi = new ModelPanelInside();
        this.mpi.setModel(this);
        this.modelPanel = new ModelPanel();
        this.modelPanel.setModel(this);
    }

    public void writeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
    }

    public JFrame getFrame() {
        return this.modelFolder.getFrame();
    }

    public ModelPanel getModelPanel() {
        return this.modelPanel;
    }

    public void setTool(int n) {
        this.tool = n;
    }

    public int getTool() {
        return this.tool;
    }

    public ModelFolder getModelFolder() {
        return this.modelFolder;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public boolean isValid() {
        boolean bl = true;
        bl &= this.stateArr.isValid();
        bl &= this.flowArr.isValid();
        return bl &= this.interArr.isValid();
    }

    public boolean isEmpty() {
        int n = 0;
        n += this.stateArr.length();
        n += this.interArr.length();
        return (n += this.flowArr.length()) == 0;
    }

    public EConnectionArray getConnectionArray() {
        return this.connArr;
    }

    public Rectangle2D.Double getDrawingRect() {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.x = -1.0;
        double_.y = -1.0;
        double_.width = 0.0;
        double_.height = 0.0;
        if (!this.isEmpty()) {
            if (this.stateArr.length() > 0) {
                double_.x = this.stateArr.getElement((int)0).getTotalLocation().x;
                double_.y = this.stateArr.getElement((int)0).getTotalLocation().y;
                double_.width = this.stateArr.getElement((int)0).getTotalLocation().width;
                double_.height = this.stateArr.getElement((int)0).getTotalLocation().height;
            } else if (this.flowArr.length() > 0) {
                double_.x = this.flowArr.getElement((int)0).getTotalLocation().x;
                double_.y = this.flowArr.getElement((int)0).getTotalLocation().y;
                double_.width = this.flowArr.getElement((int)0).getTotalLocation().width;
                double_.height = this.flowArr.getElement((int)0).getTotalLocation().height;
            } else if (this.interArr.length() > 0) {
                double_.x = this.interArr.getElement((int)0).getTotalLocation().x;
                double_.y = this.interArr.getElement((int)0).getTotalLocation().y;
                double_.width = this.interArr.getElement((int)0).getTotalLocation().width;
                double_.height = this.interArr.getElement((int)0).getTotalLocation().height;
            }
            int n = 0;
            while (n < this.stateArr.length()) {
                double_.add(this.stateArr.getElement(n).getTotalLocation());
                ++n;
            }
            int n2 = 0;
            while (n2 < this.flowArr.length()) {
                double_.add(this.flowArr.getElement(n2).getTotalLocation());
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.interArr.length()) {
                double_.add(this.interArr.getElement(n3).getTotalLocation());
                ++n3;
            }
        } else {
            double_.x = 50.0;
            double_.y = 50.0;
            double_.width = 0.0;
            double_.height = 0.0;
        }
        double_.x -= 50.0;
        double_.y -= 50.0;
        double_.width += 100.0;
        double_.height += 100.0;
        return double_;
    }

    public void copyContent() {
        Rectangle2D.Double double_ = this.getDrawingRect();
        Image image = this.mpi.createImage((int)double_.width, (int)double_.height);
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.translate(-double_.x, -double_.y);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect((int)double_.x - 1, (int)double_.y - 1, (int)double_.width + 2, (int)double_.height + 2);
        this.draw2D(graphics2D, this.mpi);
        SystemClipboard.setImageToClipboard(image);
    }

    public EFlowArray getFlowArray() {
        return this.flowArr;
    }

    public EIntermediateValueArray getIntermediateValueArray() {
        return this.interArr;
    }

    public EStateArray getStateArray() {
        return this.stateArr;
    }

    public void putNewState(int n, int n2) {
        EState eState = this.stateArr.createNewState();
        eState.setPosition(n, n2);
        this.mpi.repaint();
    }

    public void putNewIntermediateValue(int n, int n2) {
        EIntermediateValue eIntermediateValue = this.interArr.createNewIntermediateValue();
        eIntermediateValue.setPosition(n, n2);
        this.mpi.repaint();
    }

    public void putNewConnection(ModelElement modelElement, ModelElement modelElement2) {
        if (!(modelElement instanceof EConnection || modelElement2 instanceof EConnection || modelElement2 instanceof EState || modelElement2 == modelElement || modelElement2 == null || modelElement == null)) {
            EConnection eConnection = this.connArr.createNewConnection(modelElement.getId(), modelElement2.getId());
            if (eConnection != null) {
                eConnection.recalculateCoordinates();
                modelElement2.doValidation();
            }
            this.mpi.repaint();
        } else {
            Message.write("DIESE CONNECTION KANN NICHT ERSTELLT WERDEN");
        }
    }

    public void putNewFlow(IDElement iDElement, IDElement iDElement2, Point2D.Double double_, Point2D.Double double_2) {
        if (iDElement != iDElement2) {
            EFlow eFlow = this.flowArr.createNewFlow();
            eFlow.setFrom(iDElement);
            eFlow.setTo(iDElement2);
            eFlow.setStartingValues(double_, double_2);
            eFlow.recalculateCoordinates();
        }
        this.mpi.repaint();
    }

    public void removeMarks() {
        this.stateArr.removeMarks();
        this.connArr.removeMarks();
        this.flowArr.removeMarks();
        this.interArr.removeMarks();
        this.mepArr.clear();
    }

    public ModelPanelInside getModelPanelInside() {
        return this.mpi;
    }

    public void addMarkedPanel(ModelElementPanel modelElementPanel) {
        this.mepArr.addElement(modelElementPanel);
    }

    public void removeMarkedPanel(ModelElementPanel modelElementPanel) {
        this.mepArr.removeElement(modelElementPanel);
    }

    public void moveMarkedPanels(int n, int n2) {
        this.mepArr.moveAll(n, n2);
    }

    public void confirmMovingPanels() {
        this.mepArr.confirmAll();
        int n = this.mepArr.length();
        int n2 = 0;
        while (n2 < n) {
            this.connArr.markAsMoving(this.mepArr.getElement(n2).getModelElement().getId());
            this.flowArr.markAsMoving(this.mepArr.getElement(n2).getModelElement().getId());
            ++n2;
        }
        this.connArr.confirmConnectionMovings();
        this.flowArr.confirmFlowMovings();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D.Double double_ = this.getDrawingRect();
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double d = pageFormat.getImageableWidth() / double_.width;
            double d2 = pageFormat.getImageableHeight() / double_.height;
            d = Math.min(d, d2);
            if (d < 1.0) {
                graphics2D.scale(d, d);
            }
            graphics2D.translate(-double_.x, -double_.y);
            this.draw2D(graphics2D, this.mpi);
            return 0;
        }
        return 1;
    }

    public void printContent() {
        block3: {
            PageFormat pageFormat;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat2 = printerJob.pageDialog(pageFormat = printerJob.defaultPage());
            if (pageFormat2 == pageFormat) break block3;
            printerJob.setPrintable(this, pageFormat2);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void setSimulator(Simulator simulator) {
        this.simulator = simulator;
    }

    public Simulator getSimulator() {
        return this.simulator;
    }

    public void newOuterBound(double d, double d2) {
        this.mpi.checkSize();
    }

    public Dimension getSize() {
        return this.mpi.getPreferredSize();
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(2.0f));
        this.flowArr.draw2D(graphics2D, jComponent);
        this.connArr.draw2D(graphics2D, jComponent);
        this.interArr.draw2D(graphics2D, jComponent);
        this.stateArr.draw2D(graphics2D, jComponent);
    }

    private void sortForSimulation(ModelElementFunction[] modelElementFunctionArray) {
        int n = 0;
        while (n < modelElementFunctionArray.length - 1) {
            boolean bl = true;
            int n2 = n;
            while (n2 < modelElementFunctionArray.length && bl) {
                EConnection[] eConnectionArray = this.connArr.getAllTo(modelElementFunctionArray[n2].getId());
                bl = false;
                int n3 = n;
                while (n3 < modelElementFunctionArray.length && !bl) {
                    int n4 = 0;
                    while (n4 < eConnectionArray.length && !bl) {
                        if (modelElementFunctionArray[n3].getId() == eConnectionArray[n4].getFrom()) {
                            bl = true;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                if (!bl) {
                    ModelElementFunction modelElementFunction = modelElementFunctionArray[n2];
                    modelElementFunctionArray[n2] = modelElementFunctionArray[n];
                    modelElementFunctionArray[n] = modelElementFunction;
                }
                ++n2;
            }
            if (bl) {
                Message.write("RIESENSCHEISSE BEIM SORTIEREN PASSIERT");
            }
            ++n;
        }
    }

    public ModelElementFunction[] getSortetInterFlowElements() {
        int n = 0;
        n += this.flowArr.length();
        ModelElementFunction[] modelElementFunctionArray = new ModelElementFunction[n += this.interArr.length()];
        int n2 = 0;
        while (n2 < this.interArr.length()) {
            modelElementFunctionArray[n2] = this.interArr.getElement(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.flowArr.length()) {
            modelElementFunctionArray[n3 + this.interArr.length()] = this.flowArr.getElement(n3);
            ++n3;
        }
        this.sortForSimulation(modelElementFunctionArray);
        return modelElementFunctionArray;
    }

    public void doValidation() {
        this.connArr.doValidation();
        this.flowArr.doValidation();
        this.interArr.doValidation();
        this.stateArr.doValidation();
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        this.stateArr.save(dataOutputStream);
        this.interArr.save(dataOutputStream);
        this.flowArr.save(dataOutputStream);
        this.connArr.save(dataOutputStream);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.stateArr.load(dataInputStream);
        this.interArr.load(dataInputStream);
        this.flowArr.load(dataInputStream);
        this.connArr.load(dataInputStream);
    }

    public EIntermediateValue[] getConstants() {
        return this.interArr.getConstants();
    }
}

