/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.table.LineDash;
import frei_benno.dynamic.table.LineThickness;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.swing.table.AbstractTableModel;

public class LineProperties
extends AbstractTableModel {
    private Color color;
    private LineDash dash = new LineDash();
    private LineThickness thick = new LineThickness();
    private BasicStroke stroke;
    private Stroke oldStroke;
    private Color oldColor;
    private Shape oldClip;
    private static final String[] propNames = new String[]{"Farbe", "Typ", "Dicke"};
    private static Random random = new Random(System.currentTimeMillis());

    public LineProperties() {
        this.color = new Color(random.nextFloat(), random.nextFloat(), random.nextFloat());
        try {
            this.refreshProperties();
        }
        catch (Exception exception) {}
    }

    public Color getColor() {
        return this.color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void refreshProperties() {
        this.stroke = new BasicStroke(this.thick.getThickness(), 2, 0, 1.0f, this.dash.getDash(), 0.0f);
    }

    public LineDash getDash() {
        return this.dash;
    }

    public void setDash(LineDash lineDash) {
        if (lineDash != null) {
            this.dash = lineDash;
        }
    }

    public void prepareGraphics(Graphics2D graphics2D) {
        this.oldStroke = graphics2D.getStroke();
        this.oldColor = graphics2D.getColor();
        this.oldClip = graphics2D.getClip();
        graphics2D.setColor(this.color);
        graphics2D.setStroke(this.stroke);
    }

    public void restoreGraphics(Graphics2D graphics2D) {
        graphics2D.setClip(this.oldClip);
        graphics2D.setStroke(this.oldStroke);
        graphics2D.setColor(this.oldColor);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.dash.setType(dataInputStream.readInt());
        this.thick.setType(dataInputStream.readInt());
        this.color = new Color(dataInputStream.readInt());
        this.refreshProperties();
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.dash.getType());
        dataOutputStream.writeInt(this.thick.getType());
        dataOutputStream.writeInt(this.color.getRGB());
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    public int getRowCount() {
        return 3;
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            switch (n) {
                case 0: {
                    this.color = (Color)object;
                    break;
                }
                case 1: {
                    this.dash.setType(((LineDash)object).getType());
                    break;
                }
                case 2: {
                    this.thick.setType(((LineThickness)object).getType());
                }
            }
        }
        this.refreshProperties();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return propNames[n];
        }
        switch (n) {
            case 0: {
                return this.color;
            }
            case 1: {
                return this.dash;
            }
        }
        return this.thick;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Eigenschaft";
        }
        return "Wert";
    }

    public Class getColumnClass(int n) {
        return propNames[0].getClass();
    }
}

