/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.message.Message;
import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Line;
import frei_benno.dynamic.model.ModelFile;
import frei_benno.dynamic.model.ModelFolder;
import frei_benno.dynamic.model.PhaseLine;
import frei_benno.dynamic.model.TreeElement;
import frei_benno.dynamic.model.array.LineArray;
import frei_benno.dynamic.model.id.IDElement;
import frei_benno.dynamic.model.id.IDHandler;
import frei_benno.dynamic.toolkit.SystemClipboard;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class Graphic
implements IDrawable2D,
Printable {
    private static final double ABST_LINKS = 0.05;
    private static final double ABST_RECHTS = 0.05;
    private static final double ABST_UNTEN = 0.05;
    private static final double ABST_OBEN = 0.05;
    private static final double LEGENDE = 0.2;
    private static final double LEGENDE_MAX = 120.0;
    private static final double LEGENDE_MIN = 60.0;
    private LineArray lineArr = new LineArray(this);
    private Dimension dim = new Dimension(300, 300);
    private Rectangle2D.Double rect_space = new Rectangle2D.Double(0.1, 0.1, 0.9, 0.9);
    private Rectangle2D.Double rect_legend = new Rectangle2D.Double(0.5, 0.5, 1.0, 1.0);
    private Rectangle2D.Double rect_vals = new Rectangle2D.Double(0.0, 0.0, 1000.0, 700.0);
    private AffineTransform at = new AffineTransform();
    private GeneralPath koSystem = new GeneralPath();
    private GeneralPath raster = new GeneralPath();
    private IDElement id;
    private ModelFolder modelFolder;
    private ModelFile modelFile;
    private DecimalFormat df = new DecimalFormat("##0.###E0");
    private boolean timeDiagram = true;
    private double koStepSizeX = 1.0;
    private double koStepSizeY = 3.0;
    public static final boolean TIME_DIAGRAM = true;
    public static final boolean PHASE_DIAGRAM = false;
    private StringBuffer fb = new StringBuffer();
    private double zerox;
    private double zeroy;
    private double zerox_val;
    private double zeroy_val;
    private Rectangle2D.Double rect_RealVals = new Rectangle2D.Double();
    private Rectangle2D.Double rect_SetVals = new Rectangle2D.Double();
    private static final float[] rasterdash = new float[]{5.0f, 5.0f};

    public Graphic(ModelFolder modelFolder) {
        this.modelFolder = modelFolder;
        this.modelFile = null;
        this.id = this.modelFolder.getIdHandler().createNewID("ZEITDIAGRAMM", this);
        this.timeDiagram = true;
    }

    public Graphic(ModelFile modelFile) {
        this.modelFile = modelFile;
        this.modelFolder = null;
        this.id = this.modelFile.getIdHandler().createNewID("ZEITDIAGRAMM", this);
        this.timeDiagram = true;
    }

    public Graphic(ModelFolder modelFolder, boolean bl) {
        this(modelFolder);
        this.timeDiagram = bl;
        if (!bl) {
            this.id.setName("PHASENDIAGRAMM");
        }
    }

    public Graphic(ModelFile modelFile, boolean bl) {
        this(modelFile);
        this.timeDiagram = bl;
        if (!bl) {
            this.id.setName("PHASENDIAGRAMM");
        }
    }

    public void writeNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeElement treeElement = new TreeElement();
        treeElement.setModelFolderId(null);
        treeElement.setDefinition(-1);
        treeElement.setElementId(this.getId());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(treeElement);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
    }

    public boolean isTimeDiagram() {
        return this.timeDiagram;
    }

    public JFrame getFrame() {
        if (this.modelFile == null) {
            return this.modelFolder.getFrame();
        }
        return this.modelFile.getFrame();
    }

    public void copyContent(JComponent jComponent) {
        Image image = this.getFrame().createImage(this.dim.width, this.dim.height);
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.dim.width + 1, this.dim.height + 1);
        this.draw2D(graphics2D, jComponent);
        SystemClipboard.setImageToClipboard(image);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.dim.width, this.dim.height);
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double d = pageFormat.getImageableWidth() / double_.width;
            double d2 = pageFormat.getImageableHeight() / double_.height;
            d = Math.min(d, d2);
            if (d < 1.0) {
                graphics2D.scale(d, d);
            }
            graphics2D.translate(-double_.x, -double_.y);
            Message.write("" + pageFormat.getImageableWidth());
            this.draw2D(graphics2D, null);
            return 0;
        }
        return 1;
    }

    public void printContent() {
        block3: {
            PageFormat pageFormat;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat2 = printerJob.pageDialog(pageFormat = printerJob.defaultPage());
            if (pageFormat2 == pageFormat) break block3;
            printerJob.setPrintable(this, pageFormat2);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public boolean isElementThere(IDElement iDElement) {
        return this.lineArr.isElementThere(iDElement);
    }

    /*
     * Unable to fully structure code
     */
    private String formatMe(double var1_1) {
        block4: {
            block5: {
                this.fb.setLength(0);
                this.fb.append(this.df.format(var1_1));
                if (this.fb.length() > 2 && this.fb.charAt(this.fb.length() - 1) == '0' && this.fb.charAt(this.fb.length() - 2) == 'E') {
                    this.fb.setLength(this.fb.length() - 2);
                }
                if (this.fb.length() <= 3 || this.fb.charAt(this.fb.length() - 1) != '3' || this.fb.charAt(this.fb.length() - 2) != '-' || this.fb.charAt(this.fb.length() - 3) != 'E' || this.fb.indexOf(".") != -1) break block4;
                this.fb.setLength(this.fb.length() - 3);
                if (this.fb.charAt(0) != '-') ** GOTO lbl18
                while (this.fb.length() < 4) {
                    this.fb.insert(1, '0');
                }
                this.fb.insert(1, "0.");
                break block5;
lbl-1000:
                // 1 sources

                {
                    this.fb.insert(0, '0');
lbl18:
                    // 2 sources

                    ** while (this.fb.length() < 3)
                }
lbl19:
                // 1 sources

                this.fb.insert(0, "0.");
            }
            while (this.fb.charAt(this.fb.length() - 1) == '0') {
                this.fb.setLength(this.fb.length() - 1);
            }
        }
        return this.fb.toString();
    }

    public LineArray getLineArray() {
        return this.lineArr;
    }

    public IDElement getId() {
        return this.id;
    }

    public void setId(IDElement iDElement) {
        this.id = iDElement;
    }

    public ModelFolder getModelFolder() {
        return this.modelFolder;
    }

    public ModelFile getModelFile() {
        return this.modelFile;
    }

    public void setModelFile(ModelFile modelFile) {
        this.modelFile = modelFile;
    }

    public void setModelFolder(ModelFolder modelFolder) {
        this.modelFolder = modelFolder;
    }

    public void reload() {
        this.lineArr.reload();
        this.calculateRealVals();
        this.recalculateCoordinates();
    }

    public void calculateRealVals() {
        this.rect_RealVals = this.lineArr.getRectVal();
    }

    /*
     * Unable to fully structure code
     */
    public void initialCalculation() {
        block7: {
            block6: {
                this.calculateRealVals();
                var1_1 = 1.0;
                if (!(1.0 > this.rect_RealVals.width)) ** GOTO lbl9
                while (var1_1 > this.rect_RealVals.width) {
                    var1_1 /= 10.0;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    var1_1 *= 10.0;
lbl9:
                    // 2 sources

                    ** while (var1_1 * 10.0 < this.rect_RealVals.width)
                }
            }
            while (var1_1 * 6.0 > this.rect_RealVals.width) {
                var1_1 /= 2.0;
            }
            this.koStepSizeX = var1_1;
            var1_1 = 1.0;
            if (!(1.0 > this.rect_RealVals.height)) ** GOTO lbl22
            while (var1_1 > this.rect_RealVals.width) {
                var1_1 /= 10.0;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                var1_1 *= 10.0;
lbl22:
                // 2 sources

                ** while (var1_1 * 10.0 < this.rect_RealVals.height)
            }
        }
        while (var1_1 * 6.0 > this.rect_RealVals.height) {
            var1_1 /= 2.0;
        }
        this.koStepSizeY = var1_1;
        this.setRectValues(this.rect_RealVals);
    }

    public Rectangle2D.Double getRectValues() {
        return this.rect_SetVals;
    }

    public double getStepX() {
        return this.koStepSizeX;
    }

    public double getStepY() {
        return this.koStepSizeY;
    }

    private void recalculateVals() {
        this.rect_vals.x = this.rect_SetVals.x - this.rect_SetVals.width / 2000.0;
        this.rect_vals.y = this.rect_SetVals.y - this.rect_SetVals.height / 2000.0;
        this.rect_vals.width = this.rect_SetVals.width * 1.001;
        this.rect_vals.height = this.rect_SetVals.height * 1.001;
    }

    public void setRectValues(Rectangle2D.Double double_) {
        this.rect_SetVals.x = double_.x;
        this.rect_SetVals.y = double_.y;
        this.rect_SetVals.width = double_.width;
        this.rect_SetVals.height = double_.height;
        this.recalculateVals();
    }

    public void setStepX(double d) {
        this.koStepSizeX = d;
    }

    public void setStepY(double d) {
        this.koStepSizeY = d;
    }

    private final double findGood(double d) {
        double d2 = 1.0;
        while (d2 < d) {
            d2 *= 10.0;
        }
        while (d2 > d) {
            d2 /= 10.0;
        }
        while (d / d2 < 8.0) {
            d2 /= 2.0;
        }
        return d2;
    }

    public void recalculateCoordinates() {
        if (this.koStepSizeX < 0.0) {
            this.koStepSizeX = Math.abs(this.koStepSizeX);
        }
        if (this.koStepSizeX == 0.0 || this.rect_vals.width / this.koStepSizeX < 2.0 || this.rect_vals.width / this.koStepSizeX > 20.0) {
            this.koStepSizeX = this.findGood(this.rect_vals.width);
        }
        if (this.koStepSizeY < 0.0) {
            this.koStepSizeY = Math.abs(this.koStepSizeY);
        }
        if (this.koStepSizeY == 0.0 || this.rect_vals.height / this.koStepSizeY < 2.0 || this.rect_vals.height / this.koStepSizeY > 20.0) {
            this.koStepSizeY = this.findGood(this.rect_vals.height);
        }
        this.rect_space.x = 0.05 * (double)this.dim.width;
        this.rect_space.y = 0.05 * (double)this.dim.height;
        this.rect_legend.y = this.rect_space.y + 10.0;
        this.rect_legend.height = 100.0;
        if ((double)this.dim.width * 0.2 > 120.0) {
            this.rect_space.width = (double)this.dim.width * 0.95 - 120.0;
            this.rect_legend.x = this.rect_space.x + this.rect_space.width + 10.0;
            this.rect_legend.width = 100.0;
        } else if ((double)this.dim.width * 0.2 < 60.0) {
            this.rect_space.width = (double)this.dim.width * 0.95 - 60.0;
            if (this.rect_space.width < 30.0) {
                this.rect_space.width = 30.0;
            }
            this.rect_legend.x = this.rect_space.x + this.rect_space.width + 10.0;
            this.rect_legend.width = 40.0;
        } else {
            this.rect_space.width = (double)this.dim.width * 0.75;
            this.rect_legend.x = this.rect_space.x + this.rect_space.width + 10.0;
            this.rect_legend.width = (double)this.dim.width * 0.2 - 20.0;
        }
        this.rect_space.height = (double)this.dim.height * 0.8999999999999999;
        this.at = new AffineTransform();
        this.at.translate(0.0, this.dim.height);
        this.at.scale(1.0, -1.0);
        this.at.translate(this.rect_space.x, this.rect_space.y);
        this.at.scale(this.rect_space.width / this.rect_vals.width, this.rect_space.height / this.rect_vals.height);
        this.at.translate(-this.rect_vals.x, -this.rect_vals.y);
        if (this.rect_vals.x <= 0.0 && this.rect_vals.x + this.rect_vals.width >= 0.0) {
            this.zerox = this.rect_space.x + this.rect_space.width / this.rect_vals.width * -this.rect_vals.x;
            this.zerox_val = 0.0;
        }
        if (this.rect_vals.x + this.rect_vals.width < 0.0) {
            this.zerox = this.rect_space.x + this.rect_space.width / this.rect_vals.width * (-this.rect_vals.x - (double)((int)((-this.rect_vals.x - this.rect_vals.width) / this.koStepSizeX) + 2) * this.koStepSizeX);
            this.zerox_val = (double)((int)((-this.rect_vals.x - this.rect_vals.width) / this.koStepSizeX) + 2) * -this.koStepSizeX;
        }
        if (this.rect_vals.x > 0.0) {
            this.zerox = this.rect_space.x + this.rect_space.width / this.rect_vals.width * (-this.rect_vals.x + (double)((int)(this.rect_vals.x / this.koStepSizeX) + 1) * this.koStepSizeX);
            this.zerox_val = (double)((int)(this.rect_vals.x / this.koStepSizeX) + 1) * this.koStepSizeX;
        }
        if (this.rect_vals.y <= 0.0 && this.rect_vals.y + this.rect_vals.height >= 0.0) {
            this.zeroy = this.rect_space.y + this.rect_space.height - this.rect_space.height / this.rect_vals.height * -this.rect_vals.y;
            this.zeroy_val = 0.0;
        }
        if (this.rect_vals.y + this.rect_vals.height < 0.0) {
            this.zeroy = this.rect_space.y + this.rect_space.height - this.rect_space.height / this.rect_vals.height * (-this.rect_vals.y - (double)((int)((-this.rect_vals.y - this.rect_vals.height) / this.koStepSizeY) + 1) * this.koStepSizeY);
            this.zeroy_val = (double)((int)((-this.rect_vals.y - this.rect_vals.height) / this.koStepSizeY) + 1) * -this.koStepSizeY;
        }
        if (this.rect_vals.y > 0.0) {
            this.zeroy = this.rect_space.y + this.rect_space.height - this.rect_space.height / this.rect_vals.height * (-this.rect_vals.y + (double)((int)(this.rect_vals.y / this.koStepSizeY) + 1) * this.koStepSizeY);
            this.zeroy_val = (double)((int)(this.rect_vals.y / this.koStepSizeY) + 1) * this.koStepSizeY;
        }
        this.koSystem.reset();
        this.raster.reset();
        this.koSystem.moveTo((float)this.zerox, (float)(this.rect_space.y + this.rect_space.height));
        this.koSystem.lineTo((float)this.zerox, (float)this.rect_space.y);
        this.koSystem.lineTo((float)this.zerox - 5.0f, (float)this.rect_space.y + 5.0f);
        this.koSystem.moveTo((float)this.zerox, (float)this.rect_space.y);
        this.koSystem.lineTo((float)this.zerox + 5.0f, (float)this.rect_space.y + 5.0f);
        this.koSystem.moveTo((float)this.rect_space.x, (float)this.zeroy);
        this.koSystem.lineTo((float)(this.rect_space.x + this.rect_space.width), (float)this.zeroy);
        this.koSystem.lineTo((float)(this.rect_space.x + this.rect_space.width) - 5.0f, (float)this.zeroy - 5.0f);
        this.koSystem.moveTo((float)(this.rect_space.x + this.rect_space.width), (float)this.zeroy);
        this.koSystem.lineTo((float)(this.rect_space.x + this.rect_space.width) - 5.0f, (float)this.zeroy + 5.0f);
        double d = this.rect_space.width / this.rect_vals.width * this.koStepSizeX;
        double d2 = this.zerox;
        d2 += d;
        while (d2 < this.rect_space.x + this.rect_space.width) {
            this.raster.moveTo((float)d2, (float)this.rect_space.y);
            this.raster.lineTo((float)d2, (float)(this.rect_space.y + this.rect_space.height));
            this.koSystem.moveTo((float)d2, (float)(this.zeroy - 3.0));
            this.koSystem.lineTo((float)d2, (float)(this.zeroy + 3.0));
            d2 += d;
        }
        d2 = this.zerox;
        d2 -= d;
        while (d2 > this.rect_space.x) {
            this.raster.moveTo((float)d2, (float)this.rect_space.y);
            this.raster.lineTo((float)d2, (float)(this.rect_space.y + this.rect_space.height));
            this.koSystem.moveTo((float)d2, (float)(this.zeroy - 3.0));
            this.koSystem.lineTo((float)d2, (float)(this.zeroy + 3.0));
            d2 -= d;
        }
        d = this.rect_space.height / this.rect_vals.height * this.koStepSizeY;
        d2 = this.zeroy;
        d2 += d;
        while (d2 < this.rect_space.y + this.rect_space.height) {
            this.raster.moveTo((float)this.rect_space.x, (float)d2);
            this.raster.lineTo((float)(this.rect_space.x + this.rect_space.width), (float)d2);
            this.koSystem.moveTo((float)(this.zerox - 3.0), (float)d2);
            this.koSystem.lineTo((float)(this.zerox + 3.0), (float)d2);
            d2 += d;
        }
        d2 = this.zeroy;
        d2 -= d;
        while (d2 > this.rect_space.y) {
            this.raster.moveTo((float)this.rect_space.x, (float)d2);
            this.raster.lineTo((float)(this.rect_space.x + this.rect_space.width), (float)d2);
            this.koSystem.moveTo((float)(this.zerox - 3.0), (float)d2);
            this.koSystem.lineTo((float)(this.zerox + 3.0), (float)d2);
            d2 -= d;
        }
        this.lineArr.recalculateShape(this.at);
    }

    private void setRectVals(Rectangle2D.Double double_) {
        this.rect_vals.x = double_.x;
        this.rect_vals.y = double_.y;
        this.rect_vals.width = double_.width;
        this.rect_vals.height = double_.height;
        this.recalculateCoordinates();
    }

    public void setSize(int n, int n2) {
        this.dim.width = n;
        this.dim.height = n2;
        this.recalculateCoordinates();
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public int getWidht() {
        return this.dim.width;
    }

    public int getHeight() {
        return this.dim.height;
    }

    public Dimension getSize() {
        return new Dimension(this.dim);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        this.lineArr.drawLegende(graphics2D, (float)this.rect_legend.x, (float)this.rect_legend.width, (float)this.rect_legend.y);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(Color.lightGray);
        graphics2D.setStroke(new BasicStroke(1.0f, 2, 2, 1.0f, rasterdash, 0.0f));
        graphics2D.draw(this.raster);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.koSystem);
        graphics2D.setStroke(stroke);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("sansserif", 0, 12);
        StringBuffer stringBuffer = new StringBuffer();
        double d = this.rect_space.width / this.rect_vals.width * this.koStepSizeX;
        double d2 = this.zerox;
        d2 += d;
        double d3 = this.zerox_val + this.koStepSizeX;
        while (d2 < this.rect_space.x + this.rect_space.width) {
            textLayout = new TextLayout(this.formatMe(d3), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            textLayout.draw(graphics2D, (float)(d2 - (rectangle2D.getMaxX() - rectangle2D.getMinX()) / 2.0), (float)(this.zeroy + 15.0));
            d2 += d;
            d3 += this.koStepSizeX;
        }
        d2 = this.zerox;
        d2 -= d;
        d3 = this.zerox_val - this.koStepSizeX;
        while (d2 > this.rect_space.x) {
            textLayout = new TextLayout(this.formatMe(d3), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            textLayout.draw(graphics2D, (float)(d2 - (rectangle2D.getMaxX() - rectangle2D.getMinX()) / 2.0), (float)(this.zeroy + 15.0));
            d2 -= d;
            d3 -= this.koStepSizeX;
        }
        d = this.rect_space.height / this.rect_vals.height * this.koStepSizeY;
        d2 = this.zeroy;
        d2 += d;
        d3 = this.zeroy_val - this.koStepSizeY;
        while (d2 < this.rect_space.y + this.rect_space.height) {
            textLayout = new TextLayout(this.formatMe(d3), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            textLayout.draw(graphics2D, (float)(this.zerox + 5.0), (float)(d2 + (rectangle2D.getMaxY() - rectangle2D.getMinY()) / 2.0));
            d2 += d;
            d3 -= this.koStepSizeY;
        }
        d2 = this.zeroy;
        d2 -= d;
        d3 = this.zeroy_val + this.koStepSizeY;
        while (d2 > this.rect_space.y) {
            textLayout = new TextLayout(this.formatMe(d3), font, fontRenderContext);
            rectangle2D = textLayout.getBounds();
            textLayout.draw(graphics2D, (float)(this.zerox + 5.0), (float)(d2 + (rectangle2D.getMaxY() - rectangle2D.getMinY()) / 2.0));
            d2 -= d;
            d3 += this.koStepSizeY;
        }
        Shape shape = graphics2D.getClip();
        if (shape != null) {
            Area area = new Area(shape);
            area.intersect(new Area(this.rect_space));
            graphics2D.setClip(area);
        } else {
            graphics2D.setClip(this.rect_space);
        }
        if (this.lineArr.getRectVal().height > 1.0E50) {
            int n = 3;
        }
        this.lineArr.draw2D(graphics2D, jComponent, this.at);
        graphics2D.setClip(shape);
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.id = this.getIdHandler().loadId(dataInputStream.readInt(), this);
        this.koStepSizeX = dataInputStream.readDouble();
        this.koStepSizeY = dataInputStream.readDouble();
        this.rect_SetVals.x = dataInputStream.readDouble();
        this.rect_SetVals.y = dataInputStream.readDouble();
        this.rect_SetVals.width = dataInputStream.readDouble();
        this.rect_SetVals.height = dataInputStream.readDouble();
        this.lineArr.load(dataInputStream);
        this.recalculateVals();
        this.recalculateCoordinates();
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        dataOutputStream.writeDouble(this.koStepSizeX);
        dataOutputStream.writeDouble(this.koStepSizeY);
        dataOutputStream.writeDouble(this.rect_SetVals.x);
        dataOutputStream.writeDouble(this.rect_SetVals.y);
        dataOutputStream.writeDouble(this.rect_SetVals.width);
        dataOutputStream.writeDouble(this.rect_SetVals.height);
        this.lineArr.save(dataOutputStream);
    }

    public void addLine(IDElement iDElement, IDElement iDElement2) {
        if (!this.lineArr.isSimElementThere(iDElement, iDElement2)) {
            Line line = new Line(this, iDElement, iDElement2);
            this.lineArr.addElement(line);
        } else {
            Message.write("ERROR: Diese Linie wird bereits dargestellt");
        }
    }

    public void addLine(IDElement iDElement, IDElement iDElement2, IDElement iDElement3, IDElement iDElement4) {
        if (!this.lineArr.isSimElementThere(iDElement, iDElement2, iDElement3, iDElement4)) {
            PhaseLine phaseLine = new PhaseLine(this, iDElement, iDElement2, iDElement3, iDElement4);
            this.lineArr.addElement(phaseLine);
        } else {
            Message.write("ERROR: Diese Linie wird bereits dargestellt");
        }
    }

    public String toString() {
        return "  " + this.id.getName();
    }

    public IDHandler getIdHandler() {
        if (this.modelFile != null) {
            return this.modelFile.getIdHandler();
        }
        return this.modelFolder.getIdHandler();
    }
}

