/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.model;

import frei_benno.dynamic.model.IDrawable2D;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelElement;
import frei_benno.dynamic.model.graphic.Arrow;
import frei_benno.dynamic.model.graphic.EConnectionPanel;
import frei_benno.dynamic.model.graphic.ModelElementPanel;
import frei_benno.dynamic.model.id.IDElement;
import frei_benno.dynamic.toolkit.ArcCalculator;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JComponent;

public class EConnection
extends ModelElement
implements IDrawable2D {
    public static final double CONNECTION_WIDTH = 20.0;
    public static final double CONNECTION_HEIGHT = 20.0;
    private IDElement from;
    private IDElement to;
    private Point2D.Double start = new Point2D.Double(0.0, 0.0);
    private Point2D.Double stop = new Point2D.Double(1.0, 1.0);
    private Arrow arrow = new Arrow();
    private Arc2D.Double kreis;
    private boolean moving;

    public EConnection(Model model) {
        super(model);
        this.kreis = new Arc2D.Double(this.loc.x, this.loc.y, this.loc.width, this.loc.height, 0.0, 360.0, 0);
        this.moving = false;
    }

    public void recalculateCoordinates() {
        ModelElement modelElement = (ModelElement)this.from.getOwner();
        ModelElement modelElement2 = (ModelElement)this.to.getOwner();
        this.start = modelElement.getConnectionPoint2D(modelElement2.getCentre());
        this.stop = modelElement2.getConnectionPoint2D(modelElement.getCentre());
        this.setPosition(this.start.x + (this.stop.x - this.start.x - 20.0) / 2.0, this.start.y + (this.stop.y - this.start.y - 20.0) / 2.0);
        this.arrow.setCoordinates(this.start, this.stop);
    }

    public void removeUsers() {
    }

    public void setFrom(IDElement iDElement) {
        this.from = iDElement;
    }

    public void setTo(IDElement iDElement) {
        this.to = iDElement;
    }

    public IDElement getFrom() {
        return this.from;
    }

    public IDElement getTo() {
        return this.to;
    }

    protected ModelElementPanel constructSpecificPanel() {
        return new EConnectionPanel();
    }

    public double getWidth() {
        return 20.0;
    }

    public double getHeight() {
        return 20.0;
    }

    public void markAsMoving() {
        this.moving = true;
    }

    public void confirmConnectionMoving() {
        if (this.moving) {
            this.recalculateCoordinates();
            this.moving = false;
        }
    }

    public void confirmMoving() {
        this.resetMoving();
        this.setPosition(this.loc.x + (double)this.moveX, this.loc.y + (double)this.moveY);
    }

    public Point2D.Double getConnectionPoint2D(Point2D.Double double_) {
        return ArcCalculator.getRectLineIntersection(this.loc, double_);
    }

    public void draw2D(Graphics2D graphics2D, JComponent jComponent) {
        graphics2D.setColor(ModelElement.standardColor);
        this.arrow.draw2D(graphics2D, jComponent);
        if (this.mouseOver) {
            graphics2D.setColor(ModelElement.mouseOverColor);
            this.kreis.x = this.loc.x;
            this.kreis.y = this.loc.y;
            graphics2D.draw(this.kreis);
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.id.getId());
        if (this.from == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(this.from.getId());
        }
        if (this.to == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(this.to.getId());
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.id = this.model.getModelFolder().getIdHandler().loadId(n, this);
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        if (n2 >= 0) {
            this.setFrom(this.model.getModelFolder().getIdHandler().getIdElement(n2));
        } else {
            this.setFrom(null);
        }
        if (n3 >= 0) {
            this.setTo(this.model.getModelFolder().getIdHandler().getIdElement(n3));
        } else {
            this.setTo(null);
        }
        this.recalculateCoordinates();
    }
}

