/*
 * Decompiled with CFR 0.152.
 */
package frei_benno.dynamic.formula.numeric;

import frei_benno.dynamic.formula.numeric.SimValueSaver;
import frei_benno.dynamic.formula.numeric.Simulator;
import frei_benno.dynamic.model.EState;
import frei_benno.dynamic.model.Model;
import frei_benno.dynamic.model.ModelElementFunction;
import frei_benno.dynamic.model.Simulation;
import frei_benno.dynamic.model.array.EFlowArray;
import frei_benno.dynamic.model.array.EStateArray;
import frei_benno.dynamic.model.id.IDElement;

public class SimulatorEuler
extends Simulator {
    public static final int MAX_STEPS = 1000;
    public static final String[] neededValues = new String[]{"Startzeit", "Stopzeit", "Speicherintervall", "Schrittweite"};
    public static final double[] neededValuesStandard = new double[]{0.0, 10.0, 0.1, 0.1};
    private double actualtime;
    private ModelElementFunction[] funArr;
    private EStateArray stateArr;

    public double getOldValue(IDElement iDElement, double d, double d2) {
        if (iDElement.getOwner() instanceof EState) {
            int n = this.stateArr.getIndexOf(iDElement);
            return this.simValueSaver.oldValue(0, n, this.actualtime - d, d2);
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.funArr.length && n == -1) {
            if (this.funArr[n2].getId() == iDElement) {
                n = n2;
            }
            ++n2;
        }
        return this.simValueSaver.oldValue(1, n, this.actualtime - d, d2);
    }

    public boolean isValid() {
        boolean bl = true;
        this.errorMessages.setLength(0);
        return true;
    }

    public void simulate(Model model, Simulation simulation) {
        int n;
        int n2;
        model.setSimulator(this);
        double d = this.simProperties.getValue("Startzeit");
        double d2 = this.simProperties.getValue("Stopzeit");
        this.actualtime = d;
        double d3 = this.simProperties.getValue("Schrittweite");
        double d4 = this.simProperties.getValue("Speicherintervall");
        int n3 = Math.round((float)d4 / (float)d3);
        if (n3 <= 0) {
            n3 = 1;
        }
        this.stateArr = model.getStateArray();
        this.stateArr.resetFlows();
        EFlowArray eFlowArray = model.getFlowArray();
        eFlowArray.activateSimulation();
        this.funArr = model.getSortetInterFlowElements();
        this.simValueSaver = new SimValueSaver(this, 1, this.stateArr.length(), this.funArr.length);
        model.setTime(this.actualtime);
        this.stateArr.setAllToStartValue();
        int n4 = 0;
        while (n4 < this.funArr.length) {
            this.funArr[n4].reeval();
            ++n4;
        }
        this.simValueSaver.addTimeValue(0, this.actualtime);
        int n5 = 0;
        while (n5 < this.stateArr.length()) {
            this.simValueSaver.addStateValue(n5, this.stateArr.getElement(n5).getValue());
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.funArr.length) {
            this.simValueSaver.addInterFlowValue(n6, this.funArr[n6].getValue());
            ++n6;
        }
        this.simValueSaver.finishStep();
        int n7 = 0;
        while (this.actualtime < d2) {
            eFlowArray.letItFlow(d3);
            this.stateArr.approveFlows();
            this.actualtime = d + (double)(++n7) * d3;
            model.setTime(this.actualtime);
            int n8 = 0;
            while (n8 < this.funArr.length) {
                this.funArr[n8].reeval();
                ++n8;
            }
            if (n7 % n3 != 0 && !(this.actualtime >= d2)) continue;
            this.simValueSaver.addTimeValue(0, this.actualtime);
            n2 = 0;
            while (n2 < this.stateArr.length()) {
                this.simValueSaver.addStateValue(n2, this.stateArr.getElement(n2).getValue());
                ++n2;
            }
            n = 0;
            while (n < this.funArr.length) {
                this.simValueSaver.addInterFlowValue(n, this.funArr[n].getValue());
                ++n;
            }
            this.simValueSaver.finishStep();
        }
        eFlowArray.deactivateSimulation();
        IDElement[] iDElementArray = new IDElement[1 + this.stateArr.length() + this.funArr.length];
        iDElementArray[0] = null;
        n2 = 0;
        while (n2 < this.stateArr.length()) {
            iDElementArray[1 + n2] = this.stateArr.getElement(n2).getId();
            ++n2;
        }
        n = 0;
        while (n < this.funArr.length) {
            iDElementArray[1 + this.stateArr.length() + n] = this.funArr[n].getId();
            ++n;
        }
        simulation.setIDList(iDElementArray);
        simulation.setValuesList(this.simValueSaver.getValArray());
        this.simValueSaver = null;
    }
}

